# RECONNECTIFLY BACKEND DEBUG MODE
Write-Host "========================================" -ForegroundColor Cyan
Write-Host "   RECONNECTIFLY BACKEND DEBUG MODE" -ForegroundColor Cyan
Write-Host "========================================" -ForegroundColor Cyan
Write-Host ""

# Set environment variables for debugging
$env:NODE_ENV = "development"
$env:DEBUG = "*"
$env:LOG_LEVEL = "debug"

Write-Host "[DEBUG] Environment: $env:NODE_ENV" -ForegroundColor Yellow
Write-Host "[DEBUG] Log Level: $env:LOG_LEVEL" -ForegroundColor Yellow
Write-Host "[DEBUG] Debug Mode: $env:DEBUG" -ForegroundColor Yellow
Write-Host ""

# Create logs directory if it doesn't exist
if (!(Test-Path "logs")) {
    New-Item -ItemType Directory -Path "logs" | Out-Null
}

Write-Host "[DEBUG] Starting server with comprehensive logging..." -ForegroundColor Green
Write-Host "[DEBUG] Logs will be saved to: ./logs/" -ForegroundColor Green
Write-Host "[DEBUG] Console output: Enhanced with colors and timestamps" -ForegroundColor Green
Write-Host "[DEBUG] Health check: http://localhost:5500/api/health" -ForegroundColor Green
Write-Host ""

# Start the debug server
node debug-server.js
