const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api/posts';

// Test function to check user posts endpoint
async function testUserPosts() {
    console.log('🧪 Testing User Posts API...\n');

    try {
        // Test 1: Get user posts (replace with actual user ID)
        console.log('1. Testing GET /api/posts/user/USER_ID');
        console.log('   Note: Replace USER_ID with an actual user ID from your database');
        console.log('   Example: GET /api/posts/user/507f1f77bcf86cd799439011');
        console.log('');

        // Test 2: Get user posts with recent first (default)
        console.log('2. Testing GET /api/posts/user/USER_ID?sortBy=createdAt&sortOrder=desc');
        console.log('   This will show the most recent posts first (default behavior)');
        console.log('');

        // Test 3: Get user posts by category
        console.log('3. Testing GET /api/posts/user/USER_ID?category=general');
        console.log('   This will filter posts by category');
        console.log('');

        // Test 4: Get user posts by interests
        console.log('4. Testing GET /api/posts/user/USER_ID?interests=Technology,Programming');
        console.log('   This will filter posts by interests');
        console.log('');

        // Test 5: Get user posts sorted by likes
        console.log('5. Testing GET /api/posts/user/USER_ID?sortBy=likes&sortOrder=desc');
        console.log('   This will show posts with most likes first');
        console.log('');

        // Test 6: Get user posts with pagination
        console.log('6. Testing GET /api/posts/user/USER_ID?page=1&limit=5');
        console.log('   This will get first 5 posts with pagination');
        console.log('');

        console.log('🎉 User Posts API Endpoints Summary:');
        console.log('GET /api/posts/user/:userId - Get user posts (recent first by default)');
        console.log('GET /api/posts/user/:userId?sortBy=createdAt&sortOrder=desc - Recent posts first');
        console.log('GET /api/posts/user/:userId?sortBy=likes&sortOrder=desc - Most liked posts first');
        console.log('GET /api/posts/user/:userId?category=general - Filter by category');
        console.log('GET /api/posts/user/:userId?interests=Technology - Filter by interests');
        console.log('GET /api/posts/user/:userId?page=1&limit=10 - Pagination');
        console.log('');
        console.log('📋 Query Parameters:');
        console.log('- page: Page number (default: 1)');
        console.log('- limit: Posts per page (default: 10)');
        console.log('- sortBy: createdAt, updatedAt, likes (default: createdAt)');
        console.log('- sortOrder: desc, asc (default: desc)');
        console.log('- category: Filter by post category');
        console.log('- interests: Filter by interests (comma-separated)');
        console.log('');
        console.log('💡 The endpoint automatically shows recent posts first!');

    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        
        if (error.code === 'ECONNREFUSED') {
            console.log('\n💡 Make sure the server is running on http://localhost:5500');
            console.log('   Run: npm start or node server.js');
        }
    }
}

// Run the tests
testUserPosts();
