const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api/posts';

// Test function to check user post count endpoint
async function testUserPostCount() {
    console.log('🧪 Testing User Post Count API...\n');

    try {
        // Test 1: Get total post count for user
        console.log('1. Testing GET /api/posts/user/USER_ID/count');
        console.log('   This will return the total number of posts for a user');
        console.log('   Example: GET /api/posts/user/507f1f77bcf86cd799439011/count');
        console.log('');

        // Test 2: Get post count by category
        console.log('2. Testing GET /api/posts/user/USER_ID/count?category=general');
        console.log('   This will return the count of posts in a specific category');
        console.log('');

        // Test 3: Get post count by interests
        console.log('3. Testing GET /api/posts/user/USER_ID/count?interests=Technology');
        console.log('   This will return the count of posts with specific interests');
        console.log('');

        // Test 4: Get post count with multiple interests
        console.log('4. Testing GET /api/posts/user/USER_ID/count?interests=Technology,Programming');
        console.log('   This will return the count of posts with any of the specified interests');
        console.log('');

        console.log('🎉 User Post Count API Endpoints Summary:');
        console.log('GET /api/posts/user/:userId/count - Get total post count');
        console.log('GET /api/posts/user/:userId/count?category=general - Count by category');
        console.log('GET /api/posts/user/:userId/count?interests=Technology - Count by interests');
        console.log('');
        console.log('📋 Response includes:');
        console.log('- totalPosts: Total number of posts');
        console.log('- recentPosts: Posts in last 30 days');
        console.log('- categoryBreakdown: Count by each category');
        console.log('- topInterests: Top 10 interests with counts');
        console.log('- filter: Applied filters');
        console.log('');
        console.log('💡 Perfect for user profiles and analytics!');

    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        
        if (error.code === 'ECONNREFUSED') {
            console.log('\n💡 Make sure the server is running on http://localhost:5500');
            console.log('   Run: npm start or node server.js');
        }
    }
}

// Run the tests
testUserPostCount();
