const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api/users';

async function testCollegeDetailsAPI() {
    console.log('🎓 Testing College Details API Endpoints\n');
    
    const testUserId = '68c7ef413c86477b3b626172'; // Replace with actual user ID
    
    try {
        // Test 1: Get college details (should return null initially)
        console.log('📋 Test 1: Get college details');
        console.log(`GET /api/users/college-details/${testUserId}`);
        const response1 = await axios.get(`${BASE_URL}/college-details/${testUserId}`);
        console.log('✅ Status:', response1.status);
        console.log('📊 Response:', JSON.stringify(response1.data, null, 2));
        console.log('---\n');
        
        // Test 2: Update college details
        console.log('📋 Test 2: Update college details');
        console.log(`PUT /api/users/college-details/${testUserId}`);
        
        const collegeDetailsData = {
            graduationStatus: 'current',
            collegeCode: 'C-35789',
            collegeName: 'A.A. Government Arts College, Musiri - 621 201.',
            courseName: 'Bachelor of Computer Science',
            courseSubBranch: 'Computer Science and Engineering',
            academicYear: '2023-2027',
            selectOnYear: '2023'
        };
        
        console.log('📝 Request Body:', JSON.stringify(collegeDetailsData, null, 2));
        
        const response2 = await axios.put(`${BASE_URL}/college-details/${testUserId}`, collegeDetailsData, {
            headers: {
                'Authorization': 'Bearer YOUR_JWT_TOKEN_HERE', // Replace with actual token
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Status:', response2.status);
        console.log('📊 Response:', JSON.stringify(response2.data, null, 2));
        console.log('---\n');
        
        // Test 3: Get updated college details
        console.log('📋 Test 3: Get updated college details');
        console.log(`GET /api/users/college-details/${testUserId}`);
        const response3 = await axios.get(`${BASE_URL}/college-details/${testUserId}`);
        console.log('✅ Status:', response3.status);
        console.log('📊 Response:', JSON.stringify(response3.data, null, 2));
        console.log('---\n');
        
        // Test 4: Update with partial data
        console.log('📋 Test 4: Update with partial data');
        console.log(`PUT /api/users/college-details/${testUserId}`);
        
        const partialUpdateData = {
            graduationStatus: 'completed',
            academicYear: '2024'
        };
        
        console.log('📝 Request Body:', JSON.stringify(partialUpdateData, null, 2));
        
        const response4 = await axios.put(`${BASE_URL}/college-details/${testUserId}`, partialUpdateData, {
            headers: {
                'Authorization': 'Bearer YOUR_JWT_TOKEN_HERE', // Replace with actual token
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Status:', response4.status);
        console.log('📊 Response:', JSON.stringify(response4.data, null, 2));
        console.log('---\n');
        
        // Test 5: Get final college details
        console.log('📋 Test 5: Get final college details');
        console.log(`GET /api/users/college-details/${testUserId}`);
        const response5 = await axios.get(`${BASE_URL}/college-details/${testUserId}`);
        console.log('✅ Status:', response5.status);
        console.log('📊 Response:', JSON.stringify(response5.data, null, 2));
        console.log('---\n');
        
    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        console.error('❌ Full error:', error);
    }
}

// Run the test
testCollegeDetailsAPI();
