const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api/colleges';

async function testCollegeDebugger() {
    console.log('🎓 Testing College API with Complete Debugger\n');
    
    try {
        // Test 1: Get all colleges (basic)
        console.log('📋 Test 1: Get all colleges (basic)');
        console.log('GET /api/colleges');
        console.log('🔍 This will trigger the complete debugger...\n');
        
        const response1 = await axios.get(`${BASE_URL}`);
        console.log('✅ Status:', response1.status);
        console.log('📊 Response:', JSON.stringify(response1.data, null, 2));
        console.log('---\n');
        
        // Test 2: Search colleges
        console.log('📋 Test 2: Search colleges');
        console.log('GET /api/colleges?search=Government');
        console.log('🔍 This will trigger the complete debugger...\n');
        
        const response2 = await axios.get(`${BASE_URL}?search=Government`);
        console.log('✅ Status:', response2.status);
        console.log('📊 Response:', JSON.stringify(response2.data, null, 2));
        console.log('---\n');
        
        // Test 3: Search by city
        console.log('📋 Test 3: Search by city');
        console.log('GET /api/colleges?search=Tiruchirappalli');
        console.log('🔍 This will trigger the complete debugger...\n');
        
        const response3 = await axios.get(`${BASE_URL}?search=Tiruchirappalli`);
        console.log('✅ Status:', response3.status);
        console.log('📊 Response:', JSON.stringify(response3.data, null, 2));
        console.log('---\n');
        
        // Test 4: Search by state
        console.log('📋 Test 4: Search by state');
        console.log('GET /api/colleges?search=Tamil');
        console.log('🔍 This will trigger the complete debugger...\n');
        
        const response4 = await axios.get(`${BASE_URL}?search=Tamil`);
        console.log('✅ Status:', response4.status);
        console.log('📊 Response:', JSON.stringify(response4.data, null, 2));
        console.log('---\n');
        
        // Test 5: Search by AISHE code
        console.log('📋 Test 5: Search by AISHE code');
        console.log('GET /api/colleges?search=C-35789');
        console.log('🔍 This will trigger the complete debugger...\n');
        
        const response5 = await axios.get(`${BASE_URL}?search=C-35789`);
        console.log('✅ Status:', response5.status);
        console.log('📊 Response:', JSON.stringify(response5.data, null, 2));
        console.log('---\n');
        
    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        console.error('❌ Full error:', error);
    }
}

// Run the test
testCollegeDebugger();
