const mongoose = require('mongoose');
const Interests = require('../models/Interests');
const connectDB = require('../utils/db');
require('dotenv').config();

// 400+ Interests organized by categories
const interestsData = [
    // Technology & Programming
    {
        name: "Web Development",
        category: "Technology",
        description: "Building websites and web applications using various technologies"
    },
    {
        name: "Mobile App Development",
        category: "Technology",
        description: "Creating mobile applications for iOS and Android platforms"
    },
    {
        name: "Data Science",
        category: "Technology",
        description: "Analyzing and interpreting complex data to help make decisions"
    },
    {
        name: "Artificial Intelligence",
        category: "Technology",
        description: "Developing intelligent systems and machine learning algorithms"
    },
    {
        name: "Cybersecurity",
        category: "Technology",
        description: "Protecting digital systems and networks from cyber threats"
    },
    {
        name: "Cloud Computing",
        category: "Technology",
        description: "Working with cloud platforms and distributed computing"
    },
    {
        name: "Blockchain",
        category: "Technology",
        description: "Understanding decentralized technologies and cryptocurrencies"
    },
    {
        name: "Game Development",
        category: "Technology",
        description: "Creating interactive games and gaming experiences"
    },
    {
        name: "UI/UX Design",
        category: "Technology",
        description: "Designing user interfaces and user experiences for digital products"
    },
    {
        name: "DevOps",
        category: "Technology",
        description: "Managing development and operations workflows"
    },
    {
        name: "Machine Learning",
        category: "Technology",
        description: "Training computers to learn and make decisions from data"
    },
    {
        name: "Software Engineering",
        category: "Technology",
        description: "Designing and developing software systems and applications"
    },
    {
        name: "Database Management",
        category: "Technology",
        description: "Managing and optimizing database systems"
    },
    {
        name: "Network Administration",
        category: "Technology",
        description: "Managing computer networks and network infrastructure"
    },
    {
        name: "System Administration",
        category: "Technology",
        description: "Managing and maintaining computer systems and servers"
    },

    // Arts & Creative
    {
        name: "Painting",
        category: "Arts & Creative",
        description: "Creating visual art using various painting techniques and media"
    },
    {
        name: "Drawing",
        category: "Arts & Creative",
        description: "Creating images using pencils, charcoal, or other drawing tools"
    },
    {
        name: "Sculpture",
        category: "Arts & Creative",
        description: "Creating three-dimensional artworks from various materials"
    },
    {
        name: "Photography",
        category: "Arts & Creative",
        description: "Capturing and editing photographs using cameras and digital tools"
    },
    {
        name: "Digital Art",
        category: "Arts & Creative",
        description: "Creating artwork using digital tools and software"
    },
    {
        name: "Graphic Design",
        category: "Arts & Creative",
        description: "Creating visual content for communication and marketing"
    },
    {
        name: "Illustration",
        category: "Arts & Creative",
        description: "Creating visual representations of concepts, stories, or ideas"
    },
    {
        name: "Typography",
        category: "Arts & Creative",
        description: "Designing and arranging typefaces and text"
    },
    {
        name: "Calligraphy",
        category: "Arts & Creative",
        description: "The art of beautiful handwriting and lettering"
    },
    {
        name: "Pottery",
        category: "Arts & Creative",
        description: "Creating ceramic objects using clay and various techniques"
    },
    {
        name: "Jewelry Making",
        category: "Arts & Creative",
        description: "Creating decorative items and accessories"
    },
    {
        name: "Textile Design",
        category: "Arts & Creative",
        description: "Creating patterns and designs for fabrics and textiles"
    },
    {
        name: "Fashion Design",
        category: "Arts & Creative",
        description: "Creating clothing and fashion accessories"
    },
    {
        name: "Interior Design",
        category: "Arts & Creative",
        description: "Designing and decorating interior spaces"
    },
    {
        name: "Architecture",
        category: "Arts & Creative",
        description: "Designing buildings and physical structures"
    },

    // Music & Performance
    {
        name: "Guitar Playing",
        category: "Music & Performance",
        description: "Playing and mastering the guitar instrument"
    },
    {
        name: "Piano Playing",
        category: "Music & Performance",
        description: "Playing and mastering the piano or keyboard"
    },
    {
        name: "Singing",
        category: "Music & Performance",
        description: "Vocal performance and singing techniques"
    },
    {
        name: "Drumming",
        category: "Music & Performance",
        description: "Playing drums and percussion instruments"
    },
    {
        name: "Violin Playing",
        category: "Music & Performance",
        description: "Playing and mastering the violin"
    },
    {
        name: "Music Production",
        category: "Music & Performance",
        description: "Creating and producing music using digital tools"
    },
    {
        name: "DJing",
        category: "Music & Performance",
        description: "Mixing and playing music for audiences"
    },
    {
        name: "Songwriting",
        category: "Music & Performance",
        description: "Writing lyrics and composing music"
    },
    {
        name: "Dancing",
        category: "Music & Performance",
        description: "Various dance styles and choreography"
    },
    {
        name: "Acting",
        category: "Music & Performance",
        description: "Performing in theatrical productions or films"
    },
    {
        name: "Stand-up Comedy",
        category: "Music & Performance",
        description: "Performing comedic routines for live audiences"
    },
    {
        name: "Magic Tricks",
        category: "Music & Performance",
        description: "Performing illusions and magic tricks"
    },
    {
        name: "Circus Arts",
        category: "Music & Performance",
        description: "Acrobatics, juggling, and circus performance skills"
    },
    {
        name: "Musical Theater",
        category: "Music & Performance",
        description: "Combining acting, singing, and dancing in theatrical productions"
    },
    {
        name: "Opera",
        category: "Music & Performance",
        description: "Classical vocal performance and operatic singing"
    },

    // Sports & Fitness
    {
        name: "Football",
        category: "Sports & Fitness",
        description: "Playing American football or soccer"
    },
    {
        name: "Basketball",
        category: "Sports & Fitness",
        description: "Playing basketball and related skills"
    },
    {
        name: "Tennis",
        category: "Sports & Fitness",
        description: "Playing tennis and racquet sports"
    },
    {
        name: "Swimming",
        category: "Sports & Fitness",
        description: "Competitive swimming and water sports"
    },
    {
        name: "Running",
        category: "Sports & Fitness",
        description: "Jogging, marathon running, and track events"
    },
    {
        name: "Cycling",
        category: "Sports & Fitness",
        description: "Bicycle riding and cycling sports"
    },
    {
        name: "Weightlifting",
        category: "Sports & Fitness",
        description: "Strength training and bodybuilding"
    },
    {
        name: "Yoga",
        category: "Sports & Fitness",
        description: "Physical and mental wellness through yoga practice"
    },
    {
        name: "Martial Arts",
        category: "Sports & Fitness",
        description: "Various martial arts disciplines and self-defense"
    },
    {
        name: "Rock Climbing",
        category: "Sports & Fitness",
        description: "Indoor and outdoor rock climbing activities"
    },
    {
        name: "Surfing",
        category: "Sports & Fitness",
        description: "Wave riding and ocean sports"
    },
    {
        name: "Skiing",
        category: "Sports & Fitness",
        description: "Downhill and cross-country skiing"
    },
    {
        name: "Golf",
        category: "Sports & Fitness",
        description: "Playing golf and course management"
    },
    {
        name: "Baseball",
        category: "Sports & Fitness",
        description: "Playing baseball and softball"
    },
    {
        name: "Volleyball",
        category: "Sports & Fitness",
        description: "Playing volleyball and beach volleyball"
    },

    // Literature & Writing
    {
        name: "Creative Writing",
        category: "Literature & Writing",
        description: "Writing fiction, poetry, and creative content"
    },
    {
        name: "Journalism",
        category: "Literature & Writing",
        description: "News reporting and investigative writing"
    },
    {
        name: "Blogging",
        category: "Literature & Writing",
        description: "Writing and maintaining online blogs"
    },
    {
        name: "Technical Writing",
        category: "Literature & Writing",
        description: "Writing technical documentation and manuals"
    },
    {
        name: "Screenwriting",
        category: "Literature & Writing",
        description: "Writing scripts for films and television"
    },
    {
        name: "Copywriting",
        category: "Literature & Writing",
        description: "Writing marketing and advertising content"
    },
    {
        name: "Poetry",
        category: "Literature & Writing",
        description: "Writing and studying poetry"
    },
    {
        name: "Novel Writing",
        category: "Literature & Writing",
        description: "Writing long-form fiction and novels"
    },
    {
        name: "Short Story Writing",
        category: "Literature & Writing",
        description: "Writing short fiction and stories"
    },
    {
        name: "Literary Criticism",
        category: "Literature & Writing",
        description: "Analyzing and critiquing literature"
    },
    {
        name: "Editing",
        category: "Literature & Writing",
        description: "Editing and proofreading written content"
    },
    {
        name: "Translation",
        category: "Literature & Writing",
        description: "Translating text between different languages"
    },
    {
        name: "Publishing",
        category: "Literature & Writing",
        description: "Publishing and book production processes"
    },
    {
        name: "Ghostwriting",
        category: "Literature & Writing",
        description: "Writing content for others under their name"
    },
    {
        name: "Content Strategy",
        category: "Literature & Writing",
        description: "Planning and managing content creation"
    },

    // Science & Research
    {
        name: "Physics",
        category: "Science & Research",
        description: "Study of matter, energy, and their interactions"
    },
    {
        name: "Chemistry",
        category: "Science & Research",
        description: "Study of substances and their properties"
    },
    {
        name: "Biology",
        category: "Science & Research",
        description: "Study of living organisms and life processes"
    },
    {
        name: "Astronomy",
        category: "Science & Research",
        description: "Study of celestial objects and space"
    },
    {
        name: "Geology",
        category: "Science & Research",
        description: "Study of Earth's structure and processes"
    },
    {
        name: "Environmental Science",
        category: "Science & Research",
        description: "Study of environmental systems and sustainability"
    },
    {
        name: "Psychology",
        category: "Science & Research",
        description: "Study of mind and behavior"
    },
    {
        name: "Neuroscience",
        category: "Science & Research",
        description: "Study of the nervous system and brain"
    },
    {
        name: "Mathematics",
        category: "Science & Research",
        description: "Study of numbers, structures, and logical reasoning"
    },
    {
        name: "Statistics",
        category: "Science & Research",
        description: "Collection, analysis, and interpretation of data"
    },
    {
        name: "Engineering",
        category: "Science & Research",
        description: "Application of scientific principles to design and build"
    },
    {
        name: "Medicine",
        category: "Science & Research",
        description: "Study and practice of healthcare and healing"
    },
    {
        name: "Veterinary Science",
        category: "Science & Research",
        description: "Healthcare and treatment of animals"
    },
    {
        name: "Archaeology",
        category: "Science & Research",
        description: "Study of human history through artifacts and excavation"
    },
    {
        name: "Anthropology",
        category: "Science & Research",
        description: "Study of human societies and cultures"
    },

    // Business & Finance
    {
        name: "Entrepreneurship",
        category: "Business & Finance",
        description: "Starting and running new business ventures"
    },
    {
        name: "Investment",
        category: "Business & Finance",
        description: "Managing and growing financial portfolios"
    },
    {
        name: "Marketing",
        category: "Business & Finance",
        description: "Promoting products and services to customers"
    },
    {
        name: "Sales",
        category: "Business & Finance",
        description: "Selling products and services to customers"
    },
    {
        name: "Finance",
        category: "Business & Finance",
        description: "Managing money, investments, and financial planning"
    },
    {
        name: "Accounting",
        category: "Business & Finance",
        description: "Recording and analyzing financial transactions"
    },
    {
        name: "Project Management",
        category: "Business & Finance",
        description: "Planning and executing projects effectively"
    },
    {
        name: "Human Resources",
        category: "Business & Finance",
        description: "Managing people and organizational development"
    },
    {
        name: "Operations Management",
        category: "Business & Finance",
        description: "Managing business operations and processes"
    },
    {
        name: "Strategic Planning",
        category: "Business & Finance",
        description: "Long-term planning and organizational strategy"
    },
    {
        name: "Real Estate",
        category: "Business & Finance",
        description: "Buying, selling, and managing property investments"
    },
    {
        name: "Insurance",
        category: "Business & Finance",
        description: "Risk management and insurance products"
    },
    {
        name: "Supply Chain Management",
        category: "Business & Finance",
        description: "Managing the flow of goods and services"
    },
    {
        name: "International Business",
        category: "Business & Finance",
        description: "Business operations across different countries"
    },
    {
        name: "E-commerce",
        category: "Business & Finance",
        description: "Online business and digital commerce"
    },

    // Languages & Communication
    {
        name: "Spanish",
        category: "Languages & Communication",
        description: "Learning and speaking Spanish language"
    },
    {
        name: "French",
        category: "Languages & Communication",
        description: "Learning and speaking French language"
    },
    {
        name: "German",
        category: "Languages & Communication",
        description: "Learning and speaking German language"
    },
    {
        name: "Mandarin Chinese",
        category: "Languages & Communication",
        description: "Learning and speaking Mandarin Chinese"
    },
    {
        name: "Japanese",
        category: "Languages & Communication",
        description: "Learning and speaking Japanese language"
    },
    {
        name: "Korean",
        category: "Languages & Communication",
        description: "Learning and speaking Korean language"
    },
    {
        name: "Arabic",
        category: "Languages & Communication",
        description: "Learning and speaking Arabic language"
    },
    {
        name: "Portuguese",
        category: "Languages & Communication",
        description: "Learning and speaking Portuguese language"
    },
    {
        name: "Italian",
        category: "Languages & Communication",
        description: "Learning and speaking Italian language"
    },
    {
        name: "Russian",
        category: "Languages & Communication",
        description: "Learning and speaking Russian language"
    },
    {
        name: "Hindi",
        category: "Languages & Communication",
        description: "Learning and speaking Hindi language"
    },
    {
        name: "Public Speaking",
        category: "Languages & Communication",
        description: "Speaking effectively to audiences and groups"
    },
    {
        name: "Debate",
        category: "Languages & Communication",
        description: "Arguing positions and engaging in formal debates"
    },
    {
        name: "Sign Language",
        category: "Languages & Communication",
        description: "Learning and using sign language for communication"
    },
    {
        name: "Linguistics",
        category: "Languages & Communication",
        description: "Scientific study of language and its structure"
    },

    // Hobbies & Crafts
    {
        name: "Gardening",
        category: "Hobbies & Crafts",
        description: "Growing plants, flowers, and vegetables"
    },
    {
        name: "Cooking",
        category: "Hobbies & Crafts",
        description: "Preparing and creating meals and dishes"
    },
    {
        name: "Baking",
        category: "Hobbies & Crafts",
        description: "Making bread, pastries, and desserts"
    },
    {
        name: "Woodworking",
        category: "Hobbies & Crafts",
        description: "Creating objects from wood using various tools"
    },
    {
        name: "Knitting",
        category: "Hobbies & Crafts",
        description: "Creating fabric by interlocking loops of yarn"
    },
    {
        name: "Crocheting",
        category: "Hobbies & Crafts",
        description: "Creating fabric using a crochet hook and yarn"
    },
    {
        name: "Sewing",
        category: "Hobbies & Crafts",
        description: "Joining fabrics together using needle and thread"
    },
    {
        name: "Embroidery",
        category: "Hobbies & Crafts",
        description: "Decorating fabric with needlework and thread"
    },
    {
        name: "Quilting",
        category: "Hobbies & Crafts",
        description: "Creating patchwork quilts and textile art"
    },
    {
        name: "Origami",
        category: "Hobbies & Crafts",
        description: "Folding paper into decorative shapes and figures"
    },
    {
        name: "Model Building",
        category: "Hobbies & Crafts",
        description: "Building scale models of vehicles, buildings, etc."
    },
    {
        name: "Candle Making",
        category: "Hobbies & Crafts",
        description: "Creating candles from wax and other materials"
    },
    {
        name: "Soap Making",
        category: "Hobbies & Crafts",
        description: "Creating handmade soaps and bath products"
    },
    {
        name: "Scrapbooking",
        category: "Hobbies & Crafts",
        description: "Preserving memories in decorative albums"
    },
    {
        name: "Collecting",
        category: "Hobbies & Crafts",
        description: "Gathering and organizing items of interest"
    },

    // Outdoor & Nature
    {
        name: "Hiking",
        category: "Outdoor & Nature",
        description: "Walking in nature for recreation and exercise"
    },
    {
        name: "Camping",
        category: "Outdoor & Nature",
        description: "Spending time outdoors in temporary shelters"
    },
    {
        name: "Fishing",
        category: "Outdoor & Nature",
        description: "Catching fish using various techniques and equipment"
    },
    {
        name: "Hunting",
        category: "Outdoor & Nature",
        description: "Tracking and harvesting wild game"
    },
    {
        name: "Bird Watching",
        category: "Outdoor & Nature",
        description: "Observing and identifying birds in their natural habitat"
    },
    {
        name: "Wildlife Photography",
        category: "Outdoor & Nature",
        description: "Photographing animals and nature in the wild"
    },
    {
        name: "Mountain Climbing",
        category: "Outdoor & Nature",
        description: "Climbing mountains and high peaks"
    },
    {
        name: "Kayaking",
        category: "Outdoor & Nature",
        description: "Paddling small boats on rivers and lakes"
    },
    {
        name: "Canoeing",
        category: "Outdoor & Nature",
        description: "Paddling canoes on water bodies"
    },
    {
        name: "Sailing",
        category: "Outdoor & Nature",
        description: "Operating sailboats and wind-powered vessels"
    },
    {
        name: "Backpacking",
        category: "Outdoor & Nature",
        description: "Hiking with camping gear for extended trips"
    },
    {
        name: "Geocaching",
        category: "Outdoor & Nature",
        description: "Outdoor treasure hunting using GPS coordinates"
    },
    {
        name: "Stargazing",
        category: "Outdoor & Nature",
        description: "Observing stars, planets, and celestial objects"
    },
    {
        name: "Foraging",
        category: "Outdoor & Nature",
        description: "Searching for wild food and medicinal plants"
    },
    {
        name: "Nature Conservation",
        category: "Outdoor & Nature",
        description: "Protecting and preserving natural environments"
    },

    // Gaming & Entertainment
    {
        name: "Video Games",
        category: "Gaming & Entertainment",
        description: "Playing electronic games on various platforms"
    },
    {
        name: "Board Games",
        category: "Gaming & Entertainment",
        description: "Playing traditional tabletop games"
    },
    {
        name: "Card Games",
        category: "Gaming & Entertainment",
        description: "Playing games using playing cards"
    },
    {
        name: "Chess",
        category: "Gaming & Entertainment",
        description: "Strategic board game with pieces and checkered board"
    },
    {
        name: "Poker",
        category: "Gaming & Entertainment",
        description: "Card game involving betting and strategy"
    },
    {
        name: "Role-Playing Games",
        category: "Gaming & Entertainment",
        description: "Games where players assume character roles"
    },
    {
        name: "Tabletop RPGs",
        category: "Gaming & Entertainment",
        description: "Pen and paper role-playing games"
    },
    {
        name: "Puzzle Solving",
        category: "Gaming & Entertainment",
        description: "Solving various types of puzzles and brain teasers"
    },
    {
        name: "Crossword Puzzles",
        category: "Gaming & Entertainment",
        description: "Word puzzles with intersecting clues"
    },
    {
        name: "Sudoku",
        category: "Gaming & Entertainment",
        description: "Number puzzle game with logical placement"
    },
    {
        name: "Escape Rooms",
        category: "Gaming & Entertainment",
        description: "Interactive puzzle-solving experiences"
    },
    {
        name: "Fantasy Sports",
        category: "Gaming & Entertainment",
        description: "Managing virtual sports teams and competitions"
    },
    {
        name: "Collectible Card Games",
        category: "Gaming & Entertainment",
        description: "Trading card games like Magic: The Gathering"
    },
    {
        name: "Miniature Wargaming",
        category: "Gaming & Entertainment",
        description: "Strategy games using miniature figures"
    },
    {
        name: "Arcade Games",
        category: "Gaming & Entertainment",
        description: "Classic arcade and coin-operated games"
    },

    // Education & Learning
    {
        name: "Online Learning",
        category: "Education & Learning",
        description: "Taking courses and learning through online platforms"
    },
    {
        name: "Language Learning",
        category: "Education & Learning",
        description: "Learning new languages through various methods"
    },
    {
        name: "History",
        category: "Education & Learning",
        description: "Study of past events and historical periods"
    },
    {
        name: "Philosophy",
        category: "Education & Learning",
        description: "Study of fundamental questions about existence and knowledge"
    },
    {
        name: "Economics",
        category: "Education & Learning",
        description: "Study of production, distribution, and consumption of goods"
    },
    {
        name: "Political Science",
        category: "Education & Learning",
        description: "Study of government systems and political behavior"
    },
    {
        name: "Sociology",
        category: "Education & Learning",
        description: "Study of human society and social behavior"
    },
    {
        name: "Geography",
        category: "Education & Learning",
        description: "Study of Earth's landscapes and human-environment interaction"
    },
    {
        name: "Literature",
        category: "Education & Learning",
        description: "Study of written works and literary analysis"
    },
    {
        name: "Art History",
        category: "Education & Learning",
        description: "Study of art movements and historical artistic periods"
    },
    {
        name: "Music Theory",
        category: "Education & Learning",
        description: "Study of musical structure, harmony, and composition"
    },
    {
        name: "Cultural Studies",
        category: "Education & Learning",
        description: "Study of cultural practices and their meanings"
    },
    {
        name: "Religious Studies",
        category: "Education & Learning",
        description: "Study of religious beliefs, practices, and traditions"
    },
    {
        name: "Gender Studies",
        category: "Education & Learning",
        description: "Study of gender identity and social roles"
    },
    {
        name: "Environmental Studies",
        category: "Education & Learning",
        description: "Study of environmental issues and sustainability"
    },

    // Health & Wellness
    {
        name: "Meditation",
        category: "Health & Wellness",
        description: "Practice of mindfulness and mental focus"
    },
    {
        name: "Nutrition",
        category: "Health & Wellness",
        description: "Study of food and its effects on health"
    },
    {
        name: "Fitness Training",
        category: "Health & Wellness",
        description: "Physical exercise and strength conditioning"
    },
    {
        name: "Mental Health",
        category: "Health & Wellness",
        description: "Understanding and maintaining psychological well-being"
    },
    {
        name: "Alternative Medicine",
        category: "Health & Wellness",
        description: "Non-conventional approaches to healing and health"
    },
    {
        name: "Holistic Health",
        category: "Health & Wellness",
        description: "Approach to health that considers the whole person"
    },
    {
        name: "Stress Management",
        category: "Health & Wellness",
        description: "Techniques for managing and reducing stress"
    },
    {
        name: "Sleep Hygiene",
        category: "Health & Wellness",
        description: "Practices for improving sleep quality and duration"
    },
    {
        name: "Mindfulness",
        category: "Health & Wellness",
        description: "Practice of being present and aware in the moment"
    },
    {
        name: "Breathing Exercises",
        category: "Health & Wellness",
        description: "Techniques for controlled breathing and relaxation"
    },
    {
        name: "Massage Therapy",
        category: "Health & Wellness",
        description: "Therapeutic touch and bodywork for healing"
    },
    {
        name: "Aromatherapy",
        category: "Health & Wellness",
        description: "Use of essential oils for therapeutic purposes"
    },
    {
        name: "Herbal Medicine",
        category: "Health & Wellness",
        description: "Use of plants and herbs for medicinal purposes"
    },
    {
        name: "Acupuncture",
        category: "Health & Wellness",
        description: "Traditional Chinese medicine using needles"
    },
    {
        name: "Physical Therapy",
        category: "Health & Wellness",
        description: "Rehabilitation and treatment of physical injuries"
    },

    // Travel & Culture
    {
        name: "Travel Planning",
        category: "Travel & Culture",
        description: "Organizing and planning travel itineraries"
    },
    {
        name: "Cultural Immersion",
        category: "Travel & Culture",
        description: "Experiencing and learning about different cultures"
    },
    {
        name: "Food Tourism",
        category: "Travel & Culture",
        description: "Traveling to experience local cuisines and foods"
    },
    {
        name: "Adventure Travel",
        category: "Travel & Culture",
        description: "Travel involving physical activity and outdoor adventure"
    },
    {
        name: "Volunteer Travel",
        category: "Travel & Culture",
        description: "Combining travel with volunteer work and service"
    },
    {
        name: "Solo Travel",
        category: "Travel & Culture",
        description: "Traveling alone and independently"
    },
    {
        name: "Backpacking Travel",
        category: "Travel & Culture",
        description: "Budget travel with minimal luggage and accommodation"
    },
    {
        name: "Luxury Travel",
        category: "Travel & Culture",
        description: "High-end travel experiences and accommodations"
    },
    {
        name: "Eco-Tourism",
        category: "Travel & Culture",
        description: "Environmentally responsible travel and tourism"
    },
    {
        name: "Heritage Tourism",
        category: "Travel & Culture",
        description: "Travel focused on historical and cultural sites"
    },
    {
        name: "Photography Travel",
        category: "Travel & Culture",
        description: "Travel specifically for capturing photographs"
    },
    {
        name: "Educational Travel",
        category: "Travel & Culture",
        description: "Travel for learning and educational purposes"
    },
    {
        name: "Business Travel",
        category: "Travel & Culture",
        description: "Travel for work and business purposes"
    },
    {
        name: "Cruise Travel",
        category: "Travel & Culture",
        description: "Travel by cruise ship to various destinations"
    },
    {
        name: "Road Trips",
        category: "Travel & Culture",
        description: "Long-distance travel by car or motorcycle"
    },

    // Social & Community
    {
        name: "Volunteering",
        category: "Social & Community",
        description: "Giving time and effort to help others and causes"
    },
    {
        name: "Community Service",
        category: "Social & Community",
        description: "Working to improve local communities"
    },
    {
        name: "Social Work",
        category: "Social & Community",
        description: "Professional helping of individuals and families"
    },
    {
        name: "Event Planning",
        category: "Social & Community",
        description: "Organizing and coordinating events and gatherings"
    },
    {
        name: "Fundraising",
        category: "Social & Community",
        description: "Raising money for charitable causes and organizations"
    },
    {
        name: "Mentoring",
        category: "Social & Community",
        description: "Guiding and supporting others in their development"
    },
    {
        name: "Teaching",
        category: "Social & Community",
        description: "Educating and instructing others in various subjects"
    },
    {
        name: "Coaching",
        category: "Social & Community",
        description: "Training and developing others in specific skills"
    },
    {
        name: "Networking",
        category: "Social & Community",
        description: "Building professional and social connections"
    },
    {
        name: "Public Relations",
        category: "Social & Community",
        description: "Managing communication between organizations and publics"
    },
    {
        name: "Activism",
        category: "Social & Community",
        description: "Working to bring about political or social change"
    },
    {
        name: "Advocacy",
        category: "Social & Community",
        description: "Speaking up for and supporting specific causes"
    },
    {
        name: "Leadership",
        category: "Social & Community",
        description: "Guiding and inspiring others to achieve goals"
    },
    {
        name: "Team Building",
        category: "Social & Community",
        description: "Activities designed to improve team dynamics"
    },
    {
        name: "Conflict Resolution",
        category: "Social & Community",
        description: "Helping resolve disputes and disagreements"
    },

    // Home & Lifestyle
    {
        name: "Home Improvement",
        category: "Home & Lifestyle",
        description: "Renovating and upgrading home spaces"
    },
    {
        name: "DIY Projects",
        category: "Home & Lifestyle",
        description: "Do-it-yourself home and craft projects"
    },
    {
        name: "Organization",
        category: "Home & Lifestyle",
        description: "Organizing and decluttering living spaces"
    },
    {
        name: "Minimalism",
        category: "Home & Lifestyle",
        description: "Living with fewer possessions and focusing on essentials"
    },
    {
        name: "Sustainable Living",
        category: "Home & Lifestyle",
        description: "Living in an environmentally conscious way"
    },
    {
        name: "Home Automation",
        category: "Home & Lifestyle",
        description: "Using technology to control home systems"
    },
    {
        name: "Furniture Restoration",
        category: "Home & Lifestyle",
        description: "Repairing and refinishing old furniture"
    },
    {
        name: "Home Security",
        category: "Home & Lifestyle",
        description: "Protecting home and property from threats"
    },
    {
        name: "Smart Home Technology",
        category: "Home & Lifestyle",
        description: "Integrating technology into home systems"
    },
    {
        name: "Energy Efficiency",
        category: "Home & Lifestyle",
        description: "Reducing energy consumption in the home"
    },
    {
        name: "Water Conservation",
        category: "Home & Lifestyle",
        description: "Reducing water usage and waste"
    },
    {
        name: "Composting",
        category: "Home & Lifestyle",
        description: "Converting organic waste into soil amendment"
    },
    {
        name: "Urban Farming",
        category: "Home & Lifestyle",
        description: "Growing food in urban environments"
    },
    {
        name: "Home Brewing",
        category: "Home & Lifestyle",
        description: "Making beer and other beverages at home"
    },
    {
        name: "Pet Care",
        category: "Home & Lifestyle",
        description: "Caring for and training pets and animals"
    }
];

// Seed function
const seedInterests = async () => {
    try {
        console.log('Starting to seed interests...');
        
        // Clear existing interests
        await Interests.deleteMany({});
        console.log('Cleared existing interests');
        
        // Insert new interests
        const insertedInterests = await Interests.insertMany(interestsData);
        console.log(`Successfully seeded ${insertedInterests.length} interests`);
        
        // Display summary by category
        const categoryCounts = {};
        insertedInterests.forEach(interest => {
            categoryCounts[interest.category] = (categoryCounts[interest.category] || 0) + 1;
        });
        
        console.log('\nInterests seeded by category:');
        Object.entries(categoryCounts).forEach(([category, count]) => {
            console.log(`${category}: ${count} interests`);
        });
        
        console.log('\nSeeding completed successfully!');
        process.exit(0);
    } catch (error) {
        console.error('Error seeding interests:', error);
        process.exit(1);
    }
};

// Run the seed function
connectDB().then(() => {
    seedInterests();
});

module.exports = { interestsData, seedInterests };
