const mongoose = require('mongoose');
require('dotenv').config();

// Import models
const Exam = require('../models/Exam');
const College = require('../models/College');
const Quiz = require('../models/Quiz');
const CareerPath = require('../models/CareerPath');
const Certification = require('../models/Certification');
const connectDB = require('../utils/db');

// Sample Exam Data
const sampleExams = [
    // Class 6-10 Exams
    {
        name: "JNV",
        fullForm: "Jawahar Navodaya Vidyalaya",
        stage: "class_6_10",
        category: "entrance",
        conductingBody: "Navodaya Vidyalaya Samiti",
        eligibility: {
            minAge: 9,
            maxAge: 13,
            education: "Class 5 completed",
            percentage: 60
        },
        examPattern: {
            mode: "offline",
            duration: 120,
            totalMarks: 100,
            sections: [
                { name: "Mental Ability", marks: 40, questions: 40, duration: 60 },
                { name: "Arithmetic", marks: 60, questions: 40, duration: 60 }
            ]
        },
        syllabus: ["Mental Ability", "Arithmetic"],
        applicationFee: { general: 0, reserved: 0 },
        importantDates: {
            applicationStart: new Date('2024-01-01'),
            applicationEnd: new Date('2024-02-28'),
            examDate: new Date('2024-04-15'),
            resultDate: new Date('2024-05-30')
        },
        cutoffs: { general: 95, obc: 90, sc: 85, st: 85, ews: 90 },
        topColleges: ["JNV Delhi", "JNV Mumbai", "JNV Bangalore"],
        studyTips: ["Practice mental ability questions", "Focus on arithmetic basics", "Take mock tests"],
        officialWebsite: "https://navodaya.gov.in"
    },
    {
        name: "Sainik School",
        fullForm: "Sainik School Entrance Exam",
        stage: "class_6_10",
        category: "entrance",
        conductingBody: "Ministry of Defence",
        eligibility: {
            minAge: 10,
            maxAge: 12,
            education: "Class 5 completed",
            percentage: 55
        },
        examPattern: {
            mode: "offline",
            duration: 150,
            totalMarks: 300,
            sections: [
                { name: "Mathematics", marks: 100, questions: 50, duration: 60 },
                { name: "General Knowledge", marks: 100, questions: 50, duration: 45 },
                { name: "Language", marks: 100, questions: 50, duration: 45 }
            ]
        },
        syllabus: ["Mathematics", "General Knowledge", "Language"],
        applicationFee: { general: 500, reserved: 500 },
        importantDates: {
            applicationStart: new Date('2024-01-15'),
            applicationEnd: new Date('2024-03-15'),
            examDate: new Date('2024-04-20'),
            resultDate: new Date('2024-06-01')
        },
        cutoffs: { general: 200, obc: 190, sc: 180, st: 180, ews: 185 },
        topColleges: ["Sainik School Pune", "Sainik School Bhubaneswar", "Sainik School Imphal"],
        studyTips: ["Practice mathematics daily", "Read newspapers for GK", "Improve English vocabulary"],
        officialWebsite: "https://sainikschooladmission.in"
    },
    // Class 11-12 Exams
    {
        name: "JEE Main",
        fullForm: "Joint Entrance Examination Main",
        stage: "class_11_12",
        category: "entrance",
        conductingBody: "National Testing Agency",
        eligibility: {
            minAge: 17,
            maxAge: 25,
            education: "Class 12 with Physics, Chemistry, Mathematics",
            percentage: 75
        },
        examPattern: {
            mode: "online",
            duration: 180,
            totalMarks: 300,
            sections: [
                { name: "Physics", marks: 100, questions: 25, duration: 60 },
                { name: "Chemistry", marks: 100, questions: 25, duration: 60 },
                { name: "Mathematics", marks: 100, questions: 25, duration: 60 }
            ]
        },
        syllabus: ["Physics", "Chemistry", "Mathematics"],
        applicationFee: { general: 1000, reserved: 500 },
        importantDates: {
            applicationStart: new Date('2024-01-01'),
            applicationEnd: new Date('2024-01-31'),
            examDate: new Date('2024-04-01'),
            resultDate: new Date('2024-04-30')
        },
        cutoffs: { general: 95, obc: 85, sc: 75, st: 75, ews: 85 },
        topColleges: ["IIT Delhi", "IIT Bombay", "IIT Madras"],
        studyTips: ["Strong foundation in PCM", "Regular practice", "Time management"],
        officialWebsite: "https://jeemain.nta.nic.in"
    },
    {
        name: "NEET",
        fullForm: "National Eligibility cum Entrance Test",
        stage: "class_11_12",
        category: "entrance",
        conductingBody: "National Testing Agency",
        eligibility: {
            minAge: 17,
            maxAge: 25,
            education: "Class 12 with Physics, Chemistry, Biology",
            percentage: 50
        },
        examPattern: {
            mode: "offline",
            duration: 180,
            totalMarks: 720,
            sections: [
                { name: "Physics", marks: 180, questions: 45, duration: 60 },
                { name: "Chemistry", marks: 180, questions: 45, duration: 60 },
                { name: "Biology", marks: 360, questions: 90, duration: 60 }
            ]
        },
        syllabus: ["Physics", "Chemistry", "Biology"],
        applicationFee: { general: 1600, reserved: 800 },
        importantDates: {
            applicationStart: new Date('2024-03-01'),
            applicationEnd: new Date('2024-04-15'),
            examDate: new Date('2024-05-05'),
            resultDate: new Date('2024-06-14')
        },
        cutoffs: { general: 720, obc: 650, sc: 580, st: 580, ews: 650 },
        topColleges: ["AIIMS Delhi", "JIPMER Puducherry", "CMC Vellore"],
        studyTips: ["Focus on Biology", "Practice diagrams", "Mock tests regularly"],
        officialWebsite: "https://neet.nta.nic.in"
    }
];

// Sample College Data
const sampleColleges = [
    {
        name: "Indian Institute of Technology Delhi",
        type: "government",
        category: "iit",
        location: {
            state: "Delhi",
            city: "New Delhi",
            pincode: "110016",
            address: "Hauz Khas, New Delhi"
        },
        courses: [
            { name: "B.Tech Computer Science", duration: 4, type: "btech", specializations: ["AI/ML", "Data Science"] },
            { name: "B.Tech Mechanical", duration: 4, type: "btech", specializations: ["Thermal", "Design"] },
            { name: "M.Tech Computer Science", duration: 2, type: "mtech", specializations: ["AI", "ML"] }
        ],
        cutoffs: [
            { course: "B.Tech Computer Science", category: "general", exam: "JEE Advanced", cutoffRank: 100, year: 2023 },
            { course: "B.Tech Mechanical", category: "general", exam: "JEE Advanced", cutoffRank: 500, year: 2023 }
        ],
        fees: {
            tuitionFee: 100000,
            hostelFee: 60000,
            otherCharges: 20000,
            totalFirstYear: 180000
        },
        placement: {
            averagePackage: 1500000,
            highestPackage: 5000000,
            placementPercentage: 95,
            topRecruiters: ["Google", "Microsoft", "Amazon", "Apple"],
            year: 2023
        },
        facilities: ["Library", "Hostel", "Sports Complex", "Cafeteria", "Medical Center"],
        website: "https://www.iitd.ac.in",
        contact: { phone: "011-26591735", email: "admin@iitd.ac.in" },
        ranking: { nirf: 2, times: 5, outlook: 3, year: 2023 }
    },
    {
        name: "All India Institute of Medical Sciences",
        type: "government",
        category: "medical",
        location: {
            state: "Delhi",
            city: "New Delhi",
            pincode: "110029",
            address: "Ansari Nagar, New Delhi"
        },
        courses: [
            { name: "MBBS", duration: 5.5, type: "others", specializations: ["Medicine", "Surgery"] },
            { name: "MD Medicine", duration: 3, type: "others", specializations: ["Internal Medicine"] }
        ],
        cutoffs: [
            { course: "MBBS", category: "general", exam: "NEET", cutoffRank: 1, year: 2023 }
        ],
        fees: {
            tuitionFee: 5000,
            hostelFee: 10000,
            otherCharges: 5000,
            totalFirstYear: 20000
        },
        placement: {
            averagePackage: 1200000,
            highestPackage: 3000000,
            placementPercentage: 100,
            topRecruiters: ["Government Hospitals", "Private Hospitals", "Research Institutes"],
            year: 2023
        },
        facilities: ["Hospital", "Library", "Hostel", "Research Labs"],
        website: "https://www.aiims.edu",
        contact: { phone: "011-26588500", email: "info@aiims.edu" },
        ranking: { nirf: 1, times: 2, outlook: 1, year: 2023 }
    }
];

// Sample Quiz Data
const sampleQuizzes = [
    {
        question: "Who is the current Prime Minister of India?",
        options: ["Narendra Modi", "Rahul Gandhi", "Arvind Kejriwal", "Mamata Banerjee"],
        correctAnswer: 0,
        explanation: "Narendra Modi is the current Prime Minister of India since 2014.",
        category: "current_affairs",
        difficulty: "easy",
        stage: "class_6_10",
        tags: ["politics", "india"],
        source: "Government of India"
    },
    {
        question: "What is the capital of Australia?",
        options: ["Sydney", "Melbourne", "Canberra", "Perth"],
        correctAnswer: 2,
        explanation: "Canberra is the capital city of Australia.",
        category: "geography",
        difficulty: "medium",
        stage: "class_6_10",
        tags: ["geography", "capitals", "australia"],
        source: "General Knowledge"
    },
    {
        question: "Which of the following is not a programming language?",
        options: ["Python", "Java", "HTML", "JavaScript"],
        correctAnswer: 2,
        explanation: "HTML is a markup language, not a programming language.",
        category: "technology",
        difficulty: "medium",
        stage: "class_11_12",
        tags: ["programming", "computer science"],
        source: "Computer Science"
    },
    {
        question: "What is the formula for calculating compound interest?",
        options: [
            "A = P(1 + r/n)^(nt)",
            "A = P + (P × r × t)",
            "A = P × r × t",
            "A = P(1 + r)^t"
        ],
        correctAnswer: 0,
        explanation: "A = P(1 + r/n)^(nt) is the correct formula for compound interest.",
        category: "economics",
        difficulty: "hard",
        stage: "class_11_12",
        tags: ["mathematics", "finance", "compound interest"],
        source: "Mathematics"
    }
];

// Sample Career Path Data
const sampleCareerPaths = [
    {
        name: "Engineering",
        stage: "class_11_12",
        description: "Engineering is a broad field that involves applying scientific and mathematical principles to design, build, and maintain structures, machines, and systems.",
        prerequisites: ["Physics", "Chemistry", "Mathematics"],
        duration: "4 years (B.Tech)",
        salaryRange: { min: 300000, max: 1500000 },
        jobRoles: ["Software Engineer", "Mechanical Engineer", "Civil Engineer", "Electrical Engineer"],
        skillsRequired: ["Problem Solving", "Analytical Thinking", "Technical Skills", "Communication"],
        exams: ["JEE Main", "JEE Advanced", "BITSAT", "VITEEE"],
        topColleges: ["IITs", "NITs", "BITS Pilani", "Delhi Technological University"],
        pros: ["High salary potential", "Job security", "Global opportunities", "Diverse career options"],
        cons: ["Competitive entrance exams", "Long study hours", "Continuous learning required"],
        famousPersonalities: [
            { name: "Sundar Pichai", profession: "CEO Google", achievement: "Led Google to new heights" },
            { name: "Satya Nadella", profession: "CEO Microsoft", achievement: "Transformed Microsoft's culture" }
        ],
        futureScope: "Engineering continues to evolve with emerging technologies like AI, IoT, and renewable energy.",
        difficulty: "hard",
        demand: "high"
    },
    {
        name: "Medical",
        stage: "class_11_12",
        description: "Medical field involves diagnosing, treating, and preventing diseases and injuries in humans.",
        prerequisites: ["Physics", "Chemistry", "Biology"],
        duration: "5.5 years (MBBS) + 3 years (MD/MS)",
        salaryRange: { min: 500000, max: 2000000 },
        jobRoles: ["Doctor", "Surgeon", "Specialist", "Medical Researcher"],
        skillsRequired: ["Compassion", "Attention to Detail", "Stress Management", "Continuous Learning"],
        exams: ["NEET", "AIIMS", "JIPMER"],
        topColleges: ["AIIMS", "CMC Vellore", "JIPMER", "Maulana Azad Medical College"],
        pros: ["Respect in society", "Job satisfaction", "Stable career", "Good income"],
        cons: ["Long study period", "High stress", "Irregular hours", "Emotional challenges"],
        famousPersonalities: [
            { name: "Dr. Devi Shetty", profession: "Cardiac Surgeon", achievement: "Founded Narayana Health" },
            { name: "Dr. Randeep Guleria", profession: "Pulmonologist", achievement: "Former AIIMS Director" }
        ],
        futureScope: "Medical field is expanding with telemedicine, AI in healthcare, and personalized medicine.",
        difficulty: "hard",
        demand: "high"
    }
];

// Sample Certification Data
const sampleCertifications = [
    {
        name: "AWS Certified Solutions Architect",
        provider: "Amazon Web Services",
        category: "cloud_computing",
        level: "intermediate",
        duration: "3-6 months",
        cost: { amount: 15000, currency: "INR" },
        prerequisites: ["Basic understanding of cloud computing", "Linux/Windows knowledge"],
        syllabus: ["AWS Core Services", "Security", "Architecture Design", "Cost Optimization"],
        examFormat: "Multiple choice questions",
        validity: "3 years",
        salaryIncrease: { percentage: 25, description: "Average 25% salary increase" },
        jobOpportunities: ["Cloud Architect", "DevOps Engineer", "Solutions Architect"],
        difficulty: "hard",
        demand: "high",
        website: "https://aws.amazon.com/certification/"
    },
    {
        name: "Certified Data Scientist",
        provider: "IBM",
        category: "data_science",
        level: "advanced",
        duration: "6-12 months",
        cost: { amount: 25000, currency: "INR" },
        prerequisites: ["Python programming", "Statistics knowledge", "Machine Learning basics"],
        syllabus: ["Data Analysis", "Machine Learning", "Deep Learning", "Big Data"],
        examFormat: "Hands-on projects + Multiple choice",
        validity: "2 years",
        salaryIncrease: { percentage: 35, description: "Average 35% salary increase" },
        jobOpportunities: ["Data Scientist", "ML Engineer", "Data Analyst"],
        difficulty: "hard",
        demand: "high",
        website: "https://www.ibm.com/certification/"
    }
];

// Function to seed data
async function seedCareerData() {
    try {
        await connectDB();
        console.log('Connected to database');

        // Clear existing data
        await Exam.deleteMany({});
        await College.deleteMany({});
        await Quiz.deleteMany({});
        await CareerPath.deleteMany({});
        await Certification.deleteMany({});

        console.log('Cleared existing data');

        // Insert sample data
        await Exam.insertMany(sampleExams);
        console.log('✅ Inserted sample exams');

        await College.insertMany(sampleColleges);
        console.log('✅ Inserted sample colleges');

        await Quiz.insertMany(sampleQuizzes);
        console.log('✅ Inserted sample quizzes');

        await CareerPath.insertMany(sampleCareerPaths);
        console.log('✅ Inserted sample career paths');

        await Certification.insertMany(sampleCertifications);
        console.log('✅ Inserted sample certifications');

        console.log('🎉 Career data seeding completed successfully!');
        process.exit(0);
    } catch (error) {
        console.error('❌ Error seeding career data:', error);
        process.exit(1);
    }
}

// Run the seeding function
seedCareerData();
