const express = require('express');
const router = express.Router();
const {
    createOrUpdateSchoolDetailsWithoutCurrentClass,
    getSchoolDetailsWithoutCurrentClass,
    getSchoolDetailsWithoutCurrentClassById,
    updateSchoolDetailsWithoutCurrentClass,
    deleteSchoolDetailsWithoutCurrentClass,
    getSchoolCompletionWithoutCurrentClass,
    getSchools,
    getAllSchoolDetailsWithoutCurrentClass
} = require('../controllers/schoolDetailsWithoutCurrentClassController');
const { authenticateToken } = require('../middleware/auth');
const { authenticateAdminToken } = require('../middleware/adminAuth');

// Protected routes (require authentication)
router.use(authenticateToken);

// School details without current class routes
router.post('/', createOrUpdateSchoolDetailsWithoutCurrentClass);
router.get('/', getSchoolDetailsWithoutCurrentClass);
router.get('/completion', getSchoolCompletionWithoutCurrentClass);
router.get('/schools', getSchools);
router.put('/', updateSchoolDetailsWithoutCurrentClass);
router.delete('/', deleteSchoolDetailsWithoutCurrentClass);

// Admin routes
router.use(authenticateAdminToken);
router.get('/all', getAllSchoolDetailsWithoutCurrentClass);
router.get('/:id', getSchoolDetailsWithoutCurrentClassById);

module.exports = router;