const express = require('express');
const router = express.Router();
const quizController = require('../controllers/quizController');
const { authenticateToken } = require('../middleware/auth');
const { authenticateAdmin } = require('../middleware/adminAuth');

// Public Routes
router.get('/questions', quizController.getQuizQuestions);
router.get('/categories', quizController.getQuizCategories);
router.get('/leaderboard', quizController.getQuizLeaderboard);

// Public quiz submission (for demo purposes)
router.post('/submit', quizController.submitQuizAnswersSingle);
router.post('/submit-public', quizController.submitQuizAnswersPublic);

// Protected Routes
router.post('/submit-auth', authenticateToken, quizController.submitQuizAnswersSingle);
router.get('/stats', authenticateToken, quizController.getUserQuizStats);

// Admin Routes (Protected with admin authentication)
router.get('/admin', authenticateAdmin, quizController.getAllQuizQuestions);
router.post('/question', authenticateAdmin, quizController.addQuizQuestion);
router.put('/question/:quizId', authenticateAdmin, quizController.updateQuizQuestion);
router.delete('/question/:quizId', authenticateAdmin, quizController.deleteQuizQuestion);

// AI Quiz Generation Routes
router.post('/generate', quizController.generateQuizQuestions);

module.exports = router;
