const express = require('express');
const router = express.Router();
const {
    getPortfolioAnalysis,
    analyzePortfolio,
    getSkillGapAnalysis,
    getCareerAlignment
} = require('../controllers/portfolioAnalysisController');
const { authenticateToken } = require('../middleware/auth');

// Protected routes
router.get('/:userId', authenticateToken, getPortfolioAnalysis);
router.post('/:userId/analyze', authenticateToken, analyzePortfolio);
router.get('/:userId/skill-gaps', authenticateToken, getSkillGapAnalysis);
router.get('/:userId/career-alignment', authenticateToken, getCareerAlignment);

module.exports = router;
