const express = require('express');
const router = express.Router();
const {
    getAllInterests,
    getInterestsByCategory,
    getInterestById,
    getCategories,
    createInterest,
    updateInterest,
    deleteInterest
} = require('../controllers/interestsController');

// Public routes
router.get('/', getAllInterests);                    // GET /api/interests
router.get('/categories', getCategories);           // GET /api/interests/categories
router.get('/category/:category', getInterestsByCategory); // GET /api/interests/category/:category
router.get('/:id', getInterestById);                // GET /api/interests/:id

// Admin routes (protected)
router.post('/', createInterest);                   // POST /api/interests
router.put('/:id', updateInterest);                 // PUT /api/interests/:id
router.delete('/:id', deleteInterest);              // DELETE /api/interests/:id

module.exports = router;
