const express = require('express');
const router = express.Router();
const {
    getFreeEducationExams,
    getFreeEducationExam,
    getParentGuidance,
    createFreeEducationExam,
    updateFreeEducationExam
} = require('../controllers/freeEducationController');
const { authenticateAdmin } = require('../middleware/adminAuth');

// Public routes
router.get('/:stage', getFreeEducationExams);
router.get('/exam/:examId', getFreeEducationExam);
router.get('/:examId/parent-guidance', getParentGuidance);

// Admin routes
router.post('/', authenticateAdmin, createFreeEducationExam);
router.put('/:examId', authenticateAdmin, updateFreeEducationExam);

module.exports = router;
