const express = require('express');
const router = express.Router();
const {
    checkCollegeEligibility,
    getCutoffData,
    createCollegeEligibility,
    updateCollegeEligibility
} = require('../controllers/collegeEligibilityController');
const { authenticateAdmin } = require('../middleware/adminAuth');

// Public routes
router.get('/check', checkCollegeEligibility);
router.get('/cutoffs/:exam', getCutoffData);

// Admin routes
router.post('/', authenticateAdmin, createCollegeEligibility);
router.put('/:eligibilityId', authenticateAdmin, updateCollegeEligibility);

module.exports = router;
