const mongoose = require('mongoose');

const JobVsPGSchema = new mongoose.Schema({
  field: {
    type: String,
    required: true
  },
  specialization: {
    type: String,
    required: true
  },
  comparison: {
    jobAfterBtech: {
      title: String,
      salaryRange: {
        min: Number,
        max: Number
      },
      averageSalary: Number,
      growthPotential: {
        type: String,
        enum: ['low', 'medium', 'high']
      },
      timeToReach: String,
      totalEarnings: {
        year1: Number,
        year2: Number,
        year3: Number,
        year4: Number,
        year5: Number
      }
    },
    pgAfterBtech: {
      title: String,
      salaryRange: {
        min: Number,
        max: Number
      },
      averageSalary: Number,
      growthPotential: {
        type: String,
        enum: ['low', 'medium', 'high']
      },
      timeToReach: String,
      totalEarnings: {
        year1: Number,
        year2: Number,
        year3: Number,
        year4: Number,
        year5: Number
      }
    }
  },
  analysis: {
    breakEvenPoint: String,
    recommendation: String,
    reasons: [String]
  },
  isActive: {
    type: Boolean,
    default: true
  }
}, {
  timestamps: true
});

module.exports = mongoose.model('JobVsPG', JobVsPGSchema);
