const mongoose = require('mongoose');

const DecisionTreeSchema = new mongoose.Schema({
  stage: {
    type: String,
    required: true,
    enum: ['class_6_10', 'class_11_12', 'graduation', 'working_professional']
  },
  currentNode: {
    type: String,
    required: true
  },
  nextNodes: [{
    nodeId: String,
    label: String,
    description: String,
    icon: String,
    isEndNode: {
      type: Boolean,
      default: false
    }
  }],
  questions: [{
    questionId: String,
    question: String,
    options: [{
      optionId: String,
      text: String,
      nextNode: String
    }]
  }],
  isActive: {
    type: Boolean,
    default: true
  }
}, {
  timestamps: true
});

module.exports = mongoose.model('DecisionTree', DecisionTreeSchema);
