const mongoose = require('mongoose');

const CareerProgressionSchema = new mongoose.Schema({
  field: {
    type: String,
    required: true
  },
  currentLevel: {
    type: String,
    required: true
  },
  nextLevel: {
    type: String,
    required: true
  },
  progression: {
    title: String,
    description: String,
    requirements: [String],
    skillsNeeded: [String],
    certifications: [String],
    experience: String,
    salaryRange: {
      min: Number,
      max: Number
    },
    timeToReach: String
  },
  industrySwitching: [{
    fromField: String,
    toField: String,
    transitionPath: String,
    skillsToLearn: [String],
    certifications: [String],
    timeRequired: String,
    successRate: Number
  }],
  certifications: [{
    name: String,
    provider: String,
    cost: Number,
    duration: String,
    impact: {
      salaryIncrease: Number,
      careerBoost: String
    }
  }],
  isActive: {
    type: Boolean,
    default: true
  }
}, {
  timestamps: true
});

module.exports = mongoose.model('CareerProgression', CareerProgressionSchema);
