# Gemini AI Integration Setup

## Setup Instructions

1. **Get Gemini API Key:**
   - Go to [Google AI Studio](https://makersuite.google.com/app/apikey)
   - Create a new API key
   - Copy the API key

2. **Add to Environment Variables:**
   Add this line to your `.env` file:
   ```
   GEMINI_API_KEY=your-gemini-api-key-here
   ```

3. **Install Dependencies:**
   ```bash
   npm install @google/generative-ai
   ```

## Features

- **Automatic Quiz Generation**: Generate quiz questions using Gemini AI
- **Category-based Questions**: Questions tailored to specific categories (GK, Science, History, etc.)
- **Difficulty Levels**: Easy, Medium, Hard difficulty options
- **Age-appropriate Content**: Questions suitable for Class 6-10 students
- **Fallback System**: If AI fails, uses predefined fallback questions

## API Endpoint

**POST** `/api/quiz/generate`

**Request Body:**
```json
{
  "stage": "class_6_10",
  "category": "gk",
  "difficulty": "medium",
  "count": 10,
  "topic": "optional topic"
}
```

**Response:**
```json
{
  "success": true,
  "message": "Generated 10 quiz questions",
  "data": {
    "questions": [...],
    "generatedBy": "Gemini AI",
    "parameters": {...}
  }
}
```

## Usage in Flutter App

The Flutter app includes a "Generate New Questions" button that:
1. Uses the selected category and difficulty
2. Calls the Gemini AI API
3. Updates the quiz questions list
4. Shows loading dialog during generation
5. Displays success/error messages

## Fallback Questions

If Gemini AI is unavailable, the system automatically falls back to predefined questions covering:
- General Knowledge
- Science
- History
- Geography
- And more categories

This ensures the quiz system always works even without AI integration.
