const mongoose = require('mongoose');
const School = require('../models/School');

// Connect to database
const connectDB = require('../utils/db');
connectDB();

async function testSchoolModel() {
    try {
        console.log('🧪 [TEST] Testing School Model...\n');
        
        // Test the getSchoolsByVillage method
        const testVillageCode = '281109012';
        console.log(`📝 [TEST] Testing village code: ${testVillageCode}`);
        
        const schools = await School.getSchoolsByVillage(testVillageCode);
        
        console.log(`✅ [TEST] Found ${schools.length} schools`);
        if (schools.length > 0) {
            console.log(`🎉 [TEST] SUCCESS! Schools found:`);
            schools.forEach((school, index) => {
                console.log(`  ${index + 1}. ${school.school_name} (${school.udise_school_code})`);
            });
        } else {
            console.log(`⚠️ [TEST] No schools found for village code: ${testVillageCode}`);
        }
        
    } catch (error) {
        console.error('❌ [TEST] Test failed:', error.message);
    } finally {
        // Close database connection
        mongoose.connection.close();
    }
}

// Run the test
testSchoolModel();
