const axios = require('axios');

const BASE_URL = 'http://localhost:5500';

async function testProfessionStatus() {
    console.log('🧪 [TEST] Testing Profession Status API...\n');
    
    // Test cases
    const testCases = [
        {
            name: 'Valid User ID (should return false by default)',
            userId: '68c7ef413c86477b3b626172', // Replace with actual user ID
            expected: 'success'
        },
        {
            name: 'Invalid User ID',
            userId: 'invalid_user_id',
            expected: 'error'
        },
        {
            name: 'Non-existent User ID',
            userId: '507f1f77bcf86cd799439011', // Valid ObjectId format but non-existent
            expected: 'error'
        }
    ];
    
    for (const testCase of testCases) {
        try {
            console.log(`📝 [TEST] ${testCase.name}...`);
            console.log(`📝 [TEST] User ID: ${testCase.userId}`);
            
            const response = await axios.get(`${BASE_URL}/api/users/profession-status/${testCase.userId}`);
            
            if (testCase.expected === 'success') {
                console.log(`✅ [TEST] ${testCase.name} - SUCCESS`);
                console.log(`✅ [TEST] Response:`, JSON.stringify(response.data, null, 2));
                
                // Verify the response structure
                if (response.data.success && response.data.data.profession_status !== undefined) {
                    console.log(`✅ [TEST] Profession status: ${response.data.data.profession_status}`);
                } else {
                    console.log(`❌ [TEST] Invalid response structure`);
                }
            } else {
                console.log(`❌ [TEST] ${testCase.name} - UNEXPECTED SUCCESS (expected error)`);
            }
            
        } catch (error) {
            if (testCase.expected === 'error') {
                console.log(`✅ [TEST] ${testCase.name} - EXPECTED ERROR`);
                console.log(`✅ [TEST] Error:`, error.response?.data?.message || error.message);
            } else {
                console.log(`❌ [TEST] ${testCase.name} - UNEXPECTED ERROR`);
                console.log(`❌ [TEST] Error:`, error.response?.data || error.message);
            }
        }
        
        console.log('---\n');
    }
    
    console.log('🎉 [TEST] Profession status tests completed!');
}

// Run the test
testProfessionStatus().catch(console.error);
