const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api';
const authToken = 'YOUR_JWT_TOKEN_HERE'; // Replace with actual JWT token
const testUserId = '68c7ef413c86477b3b626172'; // Replace with actual user ID

const headers = {
    'Authorization': `Bearer ${authToken}`,
    'Content-Type': 'application/json'
};

async function testOccupationCompletedAPI() {
    console.log('👤 Testing Occupation Completed API\n');
    
    try {
        // Test 1: Get current user information (should include occupationCompleted)
        console.log('📋 Test 1: Get current user information');
        console.log('GET /api/users');
        const response1 = await axios.get(`${BASE_URL}/users`, { headers });
        console.log('✅ Status:', response1.status);
        console.log('📊 Response:', JSON.stringify(response1.data, null, 2));
        
        // Check if occupationCompleted field is present
        if (response1.data.data?.user?.occupationCompleted !== undefined) {
            console.log('✅ occupationCompleted field is present in response');
            console.log(`📊 occupationCompleted value: ${response1.data.data.user.occupationCompleted}`);
        } else {
            console.log('❌ occupationCompleted field is missing from response');
        }
        console.log('---\n');
        
        // Test 2: Get current user's occupation status
        console.log('📋 Test 2: Get current user occupation status');
        console.log('GET /api/users/occupation-status');
        const response2 = await axios.get(`${BASE_URL}/users/occupation-status`, { headers });
        console.log('✅ Status:', response2.status);
        console.log('📊 Response:', JSON.stringify(response2.data, null, 2));
        
        // Check if occupationCompleted field is present
        if (response2.data.data?.user?.occupationCompleted !== undefined) {
            console.log('✅ occupationCompleted field is present in occupation-status response');
            console.log(`📊 occupationCompleted value: ${response2.data.data.user.occupationCompleted}`);
        } else {
            console.log('❌ occupationCompleted field is missing from occupation-status response');
        }
        console.log('---\n');
        
        // Test 3: Get user by ID (should include occupationCompleted)
        console.log('📋 Test 3: Get user by ID');
        console.log(`GET /api/users/${testUserId}`);
        const response3 = await axios.get(`${BASE_URL}/users/${testUserId}`, { headers });
        console.log('✅ Status:', response3.status);
        console.log('📊 Response:', JSON.stringify(response3.data, null, 2));
        
        // Check if occupationCompleted field is present
        if (response3.data.data?.user?.occupationCompleted !== undefined) {
            console.log('✅ occupationCompleted field is present in get user by ID response');
            console.log(`📊 occupationCompleted value: ${response3.data.data.user.occupationCompleted}`);
        } else {
            console.log('❌ occupationCompleted field is missing from get user by ID response');
        }
        console.log('---\n');
        
        // Test 4: Get user by mobile (should include occupationCompleted in full user object)
        console.log('📋 Test 4: Get user by mobile');
        console.log('GET /api/users/mobile/9515446080'); // Replace with actual mobile number
        const response4 = await axios.get(`${BASE_URL}/users/mobile/9515446080`, { headers });
        console.log('✅ Status:', response4.status);
        console.log('📊 Response:', JSON.stringify(response4.data, null, 2));
        
        // Check if occupationCompleted field is present
        if (response4.data.data?.occupationCompleted !== undefined) {
            console.log('✅ occupationCompleted field is present in get user by mobile response');
            console.log(`📊 occupationCompleted value: ${response4.data.data.occupationCompleted}`);
        } else {
            console.log('❌ occupationCompleted field is missing from get user by mobile response');
        }
        console.log('---\n');
        
        // Test 5: Get user completion status (should include occupationCompleted)
        console.log('📋 Test 5: Get user completion status');
        console.log('GET /api/users/completion-status');
        const response5 = await axios.get(`${BASE_URL}/users/completion-status`, { headers });
        console.log('✅ Status:', response5.status);
        console.log('📊 Response:', JSON.stringify(response5.data, null, 2));
        console.log('---\n');
        
        // Test 6: Get occupation details
        console.log('📋 Test 6: Get occupation details');
        console.log('GET /api/users/occupation');
        const response6 = await axios.get(`${BASE_URL}/users/occupation`, { headers });
        console.log('✅ Status:', response6.status);
        console.log('📊 Response:', JSON.stringify(response6.data, null, 2));
        console.log('---\n');
        
        console.log('🎯 Summary:');
        console.log('✅ All routes should now include occupationCompleted field');
        console.log('✅ Flutter app can check occupationCompleted to determine if user has completed occupation setup');
        
    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        console.error('❌ Full error:', error);
        
        if (error.response?.status === 401) {
            console.log('\n💡 Authentication required. Please:');
            console.log('1. Get a valid JWT token from login/register');
            console.log('2. Replace YOUR_JWT_TOKEN_HERE with the actual token');
            console.log('3. Replace testUserId with a valid user ID');
        }
    }
}

// Run the test
testOccupationCompletedAPI();
