const axios = require('axios');

const testNewsAPI = async () => {
    try {
        console.log('🧪 Testing News API...');
        
        // Test basic connectivity
        const response = await axios.get('http://localhost:5500/health');
        console.log('✅ Health check:', response.data);
        
        // Test news categories
        const categoriesResponse = await axios.get('http://localhost:5500/api/news/categories');
        console.log('✅ Categories:', categoriesResponse.data);
        
        // Test news sources
        const sourcesResponse = await axios.get('http://localhost:5500/api/news/sources');
        console.log('✅ Sources:', sourcesResponse.data);
        
    } catch (error) {
        console.error('❌ Error:', error.message);
        if (error.response) {
            console.error('Response:', error.response.data);
        }
    }
};

testNewsAPI();
