const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api';
const testUserId = '68c7ef413c86477b3b626172'; // Replace with actual user ID
const authToken = 'YOUR_JWT_TOKEN_HERE'; // Replace with actual token

async function testGroupSchoolDetailsAPI() {
    console.log('🏫 Testing Group School Details API\n');
    
    try {
        // Test 1: Get current school details
        console.log('📋 Test 1: Get current school details');
        console.log(`GET /api/users/school-details/${testUserId}`);
        const response1 = await axios.get(`${BASE_URL}/users/school-details/${testUserId}`);
        console.log('✅ Status:', response1.status);
        console.log('📊 Response:', JSON.stringify(response1.data, null, 2));
        console.log('---\n');
        
        // Test 2: Update school details (this will create/update group)
        console.log('📋 Test 2: Update school details with group creation');
        console.log(`PUT /api/users/school-details/${testUserId}`);
        
        const schoolDetailsData = {
            schoolState: 'Tamil Nadu',
            schoolDistrict: 'Tiruchirappalli',
            schoolVillage: 'Musiri',
            schoolCode: 'SCH001',
            schoolName: 'Test School Name',
            class10thStatus: 'completed',
            academicYear: '2023-2024'
        };
        
        console.log('📝 Request Body:', JSON.stringify(schoolDetailsData, null, 2));
        
        const response2 = await axios.put(`${BASE_URL}/users/school-details/${testUserId}`, schoolDetailsData, {
            headers: {
                'Authorization': `Bearer ${authToken}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Status:', response2.status);
        console.log('📊 Response:', JSON.stringify(response2.data, null, 2));
        console.log('---\n');
        
        // Test 3: Get updated school details (should include schoolGroupId)
        console.log('📋 Test 3: Get updated school details');
        console.log(`GET /api/users/school-details/${testUserId}`);
        const response3 = await axios.get(`${BASE_URL}/users/school-details/${testUserId}`);
        console.log('✅ Status:', response3.status);
        console.log('📊 Response:', JSON.stringify(response3.data, null, 2));
        console.log('---\n');
        
        // Test 4: Get all groups
        console.log('📋 Test 4: Get all groups');
        console.log('GET /api/groups');
        const response4 = await axios.get(`${BASE_URL}/groups`);
        console.log('✅ Status:', response4.status);
        console.log('📊 Response:', JSON.stringify(response4.data, null, 2));
        console.log('---\n');
        
        // Test 5: Get groups by user
        console.log('📋 Test 5: Get groups by user');
        console.log(`GET /api/groups/user/${testUserId}`);
        const response5 = await axios.get(`${BASE_URL}/groups/user/${testUserId}`);
        console.log('✅ Status:', response5.status);
        console.log('📊 Response:', JSON.stringify(response5.data, null, 2));
        console.log('---\n');
        
        // Test 6: Get group by school ID
        const schoolId = 'SCH001_2023-2024';
        console.log('📋 Test 6: Get group by school ID');
        console.log(`GET /api/groups/school/${schoolId}`);
        const response6 = await axios.get(`${BASE_URL}/groups/school/${schoolId}`);
        console.log('✅ Status:', response6.status);
        console.log('📊 Response:', JSON.stringify(response6.data, null, 2));
        console.log('---\n');
        
        // Test 7: Update school details with same school (should use existing group)
        console.log('📋 Test 7: Update school details with same school (existing group)');
        console.log(`PUT /api/users/school-details/${testUserId}`);
        
        const sameSchoolData = {
            schoolCode: 'SCH001',
            academicYear: '2023-2024',
            schoolName: 'Updated Test School Name'
        };
        
        console.log('📝 Request Body:', JSON.stringify(sameSchoolData, null, 2));
        
        const response7 = await axios.put(`${BASE_URL}/users/school-details/${testUserId}`, sameSchoolData, {
            headers: {
                'Authorization': `Bearer ${authToken}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Status:', response7.status);
        console.log('📊 Response:', JSON.stringify(response7.data, null, 2));
        console.log('---\n');
        
        // Test 8: Update school details with different school (should create new group)
        console.log('📋 Test 8: Update school details with different school (new group)');
        console.log(`PUT /api/users/school-details/${testUserId}`);
        
        const differentSchoolData = {
            schoolCode: 'SCH002',
            academicYear: '2024-2025',
            schoolName: 'Different Test School Name'
        };
        
        console.log('📝 Request Body:', JSON.stringify(differentSchoolData, null, 2));
        
        const response8 = await axios.put(`${BASE_URL}/users/school-details/${testUserId}`, differentSchoolData, {
            headers: {
                'Authorization': `Bearer ${authToken}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Status:', response8.status);
        console.log('📊 Response:', JSON.stringify(response8.data, null, 2));
        console.log('---\n');
        
        // Test 9: Get final school details
        console.log('📋 Test 9: Get final school details');
        console.log(`GET /api/users/school-details/${testUserId}`);
        const response9 = await axios.get(`${BASE_URL}/users/school-details/${testUserId}`);
        console.log('✅ Status:', response9.status);
        console.log('📊 Response:', JSON.stringify(response9.data, null, 2));
        console.log('---\n');
        
        // Test 10: Get all groups (should show both groups)
        console.log('📋 Test 10: Get all groups (should show both groups)');
        console.log('GET /api/groups');
        const response10 = await axios.get(`${BASE_URL}/groups`);
        console.log('✅ Status:', response10.status);
        console.log('📊 Response:', JSON.stringify(response10.data, null, 2));
        console.log('---\n');
        
    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        console.error('❌ Full error:', error);
    }
}

// Run the test
testGroupSchoolDetailsAPI();
