const axios = require('axios');
const FormData = require('form-data');
const fs = require('fs');
const path = require('path');

const BASE_URL = 'http://localhost:5500/api/posts';

// Test function to check file upload functionality
async function testFileUpload() {
    console.log('🧪 Testing File Upload API...\n');

    try {
        console.log('✅ File Upload System Updated:');
        console.log('- Changed from base64 to direct file uploads');
        console.log('- Images compressed to under 750KB');
        console.log('- Files stored in /uploads/posts/ directory');
        console.log('- Support for images and videos');
        console.log('- Memory storage for processing');
        console.log('');

        console.log('📋 New File Upload Features:');
        console.log('✅ Direct file uploads (no base64)');
        console.log('✅ Automatic compression to 750KB');
        console.log('✅ File storage in posts folder');
        console.log('✅ Support for images and videos');
        console.log('✅ Unique filename generation');
        console.log('✅ File path and URL storage');
        console.log('✅ Original file metadata preserved');
        console.log('');

        console.log('🎯 API Usage:');
        console.log('POST /api/posts');
        console.log('Content-Type: multipart/form-data');
        console.log('');
        console.log('Form Data Fields:');
        console.log('- title: Post title (string)');
        console.log('- description: Post description (string)');
        console.log('- tags: Comma-separated tags (string)');
        console.log('- category: Post category (string)');
        console.log('- visibility: public/private/friends_only (string)');
        console.log('- interests: JSON array of interests (string)');
        console.log('- media: File uploads (files)');
        console.log('');

        console.log('📁 File Storage Structure:');
        console.log('uploads/posts/');
        console.log('├── post_1234567890_abc123.jpg (compressed images)');
        console.log('├── post_1234567890_def456.png (compressed images)');
        console.log('└── post_video_1234567890_ghi789.mp4 (videos)');
        console.log('');

        console.log('🔧 Compression Settings:');
        console.log('- Max image size: 750KB');
        console.log('- Quality: 85% (adjustable)');
        console.log('- Progressive JPEG');
        console.log('- WebP support');
        console.log('- Automatic resizing if needed');
        console.log('');

        console.log('📊 Response Format:');
        console.log('{');
        console.log('  "success": true,');
        console.log('  "message": "Post created successfully",');
        console.log('  "data": {');
        console.log('    "post": { ... },');
        console.log('    "mediaInfo": {');
        console.log('      "totalFiles": 2,');
        console.log('      "totalSize": 1500000,');
        console.log('      "compressedFiles": 2,');
        console.log('      "fileUrls": [');
        console.log('        "/uploads/posts/post_1234567890_abc123.jpg",');
        console.log('        "/uploads/posts/post_1234567890_def456.png"');
        console.log('      ]');
        console.log('    }');
        console.log('  }');
        console.log('}');
        console.log('');

        console.log('💡 Frontend Integration:');
        console.log('1. Use FormData for file uploads');
        console.log('2. Set Content-Type to multipart/form-data');
        console.log('3. Include files in "media" field');
        console.log('4. Send other data as form fields');
        console.log('5. Files will be automatically compressed');
        console.log('6. Get file URLs from response');
        console.log('');

        console.log('🎉 File Upload System Ready!');
        console.log('No more base64 strings - direct file uploads with compression!');

    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        
        if (error.code === 'ECONNREFUSED') {
            console.log('\n💡 Make sure the server is running on http://localhost:5500');
            console.log('   Run: npm start or node server.js');
        }
    }
}

// Run the tests
testFileUpload();
