const axios = require('axios');

const BASE_URL = 'http://localhost:5500/api';
const testUserId = '68c7ef413c86477b3b626172'; // Replace with actual user ID
const authToken = 'YOUR_JWT_TOKEN_HERE'; // Replace with actual token

async function testCollegeGroupAPI() {
    console.log('🎓 Testing College Group API\n');
    
    try {
        // Test 1: Get current college details
        console.log('📋 Test 1: Get current college details');
        console.log(`GET /api/users/college-details/${testUserId}`);
        const response1 = await axios.get(`${BASE_URL}/users/college-details/${testUserId}`);
        console.log('✅ Status:', response1.status);
        console.log('📊 Response:', JSON.stringify(response1.data, null, 2));
        console.log('---\n');
        
        // Test 2: Update college details (this will create/update group)
        console.log('📋 Test 2: Update college details with group creation');
        console.log(`PUT /api/users/college-details/${testUserId}`);
        
        const collegeDetailsData = {
            graduationStatus: 'current',
            collegeCode: 'C-35789',
            collegeName: 'A.A. Government Arts College, Musiri - 621 201.',
            courseName: 'Bachelor of Computer Science',
            courseSubBranch: 'Computer Science and Engineering',
            academicYear: '2023-2027',
            selectOnYear: '2023'
        };
        
        console.log('📝 Request Body:', JSON.stringify(collegeDetailsData, null, 2));
        
        const response2 = await axios.put(`${BASE_URL}/users/college-details/${testUserId}`, collegeDetailsData, {
            headers: {
                'Authorization': `Bearer ${authToken}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Status:', response2.status);
        console.log('📊 Response:', JSON.stringify(response2.data, null, 2));
        console.log('---\n');
        
        // Test 3: Get updated college details (should include collegeGroupId)
        console.log('📋 Test 3: Get updated college details');
        console.log(`GET /api/users/college-details/${testUserId}`);
        const response3 = await axios.get(`${BASE_URL}/users/college-details/${testUserId}`);
        console.log('✅ Status:', response3.status);
        console.log('📊 Response:', JSON.stringify(response3.data, null, 2));
        console.log('---\n');
        
        // Test 4: Get all groups
        console.log('📋 Test 4: Get all groups');
        console.log('GET /api/groups');
        const response4 = await axios.get(`${BASE_URL}/groups`);
        console.log('✅ Status:', response4.status);
        console.log('📊 Response:', JSON.stringify(response4.data, null, 2));
        console.log('---\n');
        
        // Test 5: Get groups by user
        console.log('📋 Test 5: Get groups by user');
        console.log(`GET /api/groups/user/${testUserId}`);
        const response5 = await axios.get(`${BASE_URL}/groups/user/${testUserId}`);
        console.log('✅ Status:', response5.status);
        console.log('📊 Response:', JSON.stringify(response5.data, null, 2));
        console.log('---\n');
        
        // Test 6: Get group by college ID
        const collegeId = 'C-35789_2023-2027_Bachelor of Computer Science_Computer Science and Engineering';
        console.log('📋 Test 6: Get group by college ID');
        console.log(`GET /api/groups/college/${collegeId}`);
        const response6 = await axios.get(`${BASE_URL}/groups/college/${collegeId}`);
        console.log('✅ Status:', response6.status);
        console.log('📊 Response:', JSON.stringify(response6.data, null, 2));
        console.log('---\n');
        
        // Test 7: Update college details with same college (should use existing group)
        console.log('📋 Test 7: Update college details with same college (existing group)');
        console.log(`PUT /api/users/college-details/${testUserId}`);
        
        const sameCollegeData = {
            collegeCode: 'C-35789',
            academicYear: '2023-2027',
            courseName: 'Bachelor of Computer Science',
            courseSubBranch: 'Computer Science and Engineering',
            collegeName: 'Updated College Name'
        };
        
        console.log('📝 Request Body:', JSON.stringify(sameCollegeData, null, 2));
        
        const response7 = await axios.put(`${BASE_URL}/users/college-details/${testUserId}`, sameCollegeData, {
            headers: {
                'Authorization': `Bearer ${authToken}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Status:', response7.status);
        console.log('📊 Response:', JSON.stringify(response7.data, null, 2));
        console.log('---\n');
        
        // Test 8: Update college details with different college (should create new group)
        console.log('📋 Test 8: Update college details with different college (new group)');
        console.log(`PUT /api/users/college-details/${testUserId}`);
        
        const differentCollegeData = {
            collegeCode: 'C-12345',
            academicYear: '2024-2028',
            courseName: 'Bachelor of Engineering',
            courseSubBranch: 'Mechanical Engineering',
            collegeName: 'Different College Name'
        };
        
        console.log('📝 Request Body:', JSON.stringify(differentCollegeData, null, 2));
        
        const response8 = await axios.put(`${BASE_URL}/users/college-details/${testUserId}`, differentCollegeData, {
            headers: {
                'Authorization': `Bearer ${authToken}`,
                'Content-Type': 'application/json'
            }
        });
        console.log('✅ Status:', response8.status);
        console.log('📊 Response:', JSON.stringify(response8.data, null, 2));
        console.log('---\n');
        
        // Test 9: Get final college details
        console.log('📋 Test 9: Get final college details');
        console.log(`GET /api/users/college-details/${testUserId}`);
        const response9 = await axios.get(`${BASE_URL}/users/college-details/${testUserId}`);
        console.log('✅ Status:', response9.status);
        console.log('📊 Response:', JSON.stringify(response9.data, null, 2));
        console.log('---\n');
        
        // Test 10: Get all groups (should show both school and college groups)
        console.log('📋 Test 10: Get all groups (should show both school and college groups)');
        console.log('GET /api/groups');
        const response10 = await axios.get(`${BASE_URL}/groups`);
        console.log('✅ Status:', response10.status);
        console.log('📊 Response:', JSON.stringify(response10.data, null, 2));
        console.log('---\n');
        
    } catch (error) {
        console.error('❌ Test failed:', error.response?.data || error.message);
        console.error('❌ Full error:', error);
    }
}

// Run the test
testCollegeGroupAPI();
