const axios = require('axios');

const BASE_URL = 'http://localhost:5000/api/admin';

// Test admin login
const testAdminLogin = async () => {
    try {
        console.log('🔐 Testing admin login...');
        
        const response = await axios.post(`${BASE_URL}/login`, {
            email: 'reconnectifly.rif@gmail.com',
            password: 'Reconnectifly.Rif2025'
        });
        
        console.log('✅ Login successful!');
        console.log('📊 Response:', JSON.stringify(response.data, null, 2));
        
        return response.data.data.token;
    } catch (error) {
        console.error('❌ Login failed:', error.response?.data || error.message);
        return null;
    }
};

// Test admin profile
const testAdminProfile = async (token) => {
    try {
        console.log('\n👤 Testing admin profile...');
        
        const response = await axios.get(`${BASE_URL}/profile`, {
            headers: {
                'Authorization': `Bearer ${token}`
            }
        });
        
        console.log('✅ Profile retrieved successfully!');
        console.log('📊 Response:', JSON.stringify(response.data, null, 2));
    } catch (error) {
        console.error('❌ Profile retrieval failed:', error.response?.data || error.message);
    }
};

// Test token verification
const testTokenVerification = async (token) => {
    try {
        console.log('\n🔍 Testing token verification...');
        
        const response = await axios.get(`${BASE_URL}/verify`, {
            headers: {
                'Authorization': `Bearer ${token}`
            }
        });
        
        console.log('✅ Token verification successful!');
        console.log('📊 Response:', JSON.stringify(response.data, null, 2));
    } catch (error) {
        console.error('❌ Token verification failed:', error.response?.data || error.message);
    }
};

// Test admin logout
const testAdminLogout = async (token) => {
    try {
        console.log('\n🚪 Testing admin logout...');
        
        const response = await axios.post(`${BASE_URL}/logout`, {}, {
            headers: {
                'Authorization': `Bearer ${token}`
            }
        });
        
        console.log('✅ Logout successful!');
        console.log('📊 Response:', JSON.stringify(response.data, null, 2));
    } catch (error) {
        console.error('❌ Logout failed:', error.response?.data || error.message);
    }
};

// Test invalid credentials
const testInvalidCredentials = async () => {
    try {
        console.log('\n🚫 Testing invalid credentials...');
        
        const response = await axios.post(`${BASE_URL}/login`, {
            email: 'wrong@email.com',
            password: 'wrongpassword'
        });
        
        console.log('❌ This should not succeed!');
    } catch (error) {
        console.log('✅ Invalid credentials properly rejected!');
        console.log('📊 Error Response:', JSON.stringify(error.response?.data, null, 2));
    }
};

// Run all tests
const runTests = async () => {
    console.log('🧪 Starting Admin API Tests...\n');
    
    // Test invalid credentials first
    await testInvalidCredentials();
    
    // Test valid login
    const token = await testAdminLogin();
    
    if (token) {
        // Test authenticated endpoints
        await testAdminProfile(token);
        await testTokenVerification(token);
        await testAdminLogout(token);
    }
    
    console.log('\n🏁 Admin API tests completed!');
};

// Run the tests
runTests().catch(console.error);
