const mongoose = require('mongoose');
const Product = require('../models/Product');
require('dotenv').config();

const products = [
    {
        name: 'Wireless Mouse',
        description: 'High-quality wireless mouse with ergonomic design',
        category: 'Electronics',
        subCategory: 'C1',
        imageUrl: 'assets/images/Wireless Mouse.png',
        coinsRequired: 1000,
        referralsRequired: 50,
        coinsPerReferral: 20,
        isActive: true,
        stock: 100,
        tags: ['wireless', 'mouse', 'electronics', 'computer']
    },
    {
        name: 'Ear Buds',
        description: 'Premium wireless earbuds with noise cancellation',
        category: 'Electronics',
        subCategory: 'C2',
        imageUrl: 'assets/images/Ear Buds.png',
        coinsRequired: 1500,
        referralsRequired: 75,
        coinsPerReferral: 20,
        isActive: true,
        stock: 100,
        tags: ['earbuds', 'wireless', 'audio', 'electronics']
    },
    {
        name: 'Power Bank',
        description: 'High-capacity portable power bank for all devices',
        category: 'Electronics',
        subCategory: 'C2',
        imageUrl: 'assets/images/Powerbank.png',
        coinsRequired: 1500,
        referralsRequired: 75,
        coinsPerReferral: 20,
        isActive: true,
        stock: 100,
        tags: ['powerbank', 'battery', 'portable', 'electronics']
    },
    {
        name: 'Smart Watch',
        description: 'Advanced smartwatch with health monitoring features',
        category: 'Electronics',
        subCategory: 'C3',
        imageUrl: 'assets/images/Smart Watch.png',
        coinsRequired: 2000,
        referralsRequired: 100,
        coinsPerReferral: 20,
        isActive: true,
        stock: 100,
        tags: ['smartwatch', 'fitness', 'health', 'electronics']
    }
];

async function populateProducts() {
    try {
        // Connect to MongoDB
        await mongoose.connect(process.env.MONGODB_URI || 'mongodb://localhost:27017/recon_app');
        console.log('Connected to MongoDB');

        // Clear existing products
        await Product.deleteMany({});
        console.log('Cleared existing products');

        // Insert new products
        const insertedProducts = await Product.insertMany(products);
        console.log(`✅ Successfully inserted ${insertedProducts.length} products`);

        // Display inserted products
        insertedProducts.forEach(product => {
            console.log(`📦 ${product.name} - ${product.coinsRequired} coins (${product.referralsRequired} referrals)`);
        });

    } catch (error) {
        console.error('❌ Error populating products:', error);
    } finally {
        await mongoose.disconnect();
        console.log('Disconnected from MongoDB');
    }
}

// Run the script
populateProducts();
