const express = require('express');
const router = express.Router();
const studyGroupController = require('../controllers/studyGroupController');
const { authenticateToken } = require('../middleware/auth');
const { authenticateAdmin } = require('../middleware/adminAuth');

// Study Group Routes (Protected)
router.post('/', authenticateToken, studyGroupController.createStudyGroup);
router.get('/', authenticateToken, studyGroupController.getStudyGroups);
router.get('/:groupId', authenticateToken, studyGroupController.getStudyGroupDetails);
router.post('/:groupId/join', authenticateToken, studyGroupController.joinStudyGroup);
router.delete('/:groupId/leave', authenticateToken, studyGroupController.leaveStudyGroup);

// Study Group Posts (Protected)
router.post('/:groupId/posts', authenticateToken, studyGroupController.createGroupPost);
router.get('/:groupId/posts', authenticateToken, studyGroupController.getStudyGroupPosts);
router.post('/posts/:postId/like', authenticateToken, studyGroupController.togglePostLike);
router.post('/posts/:postId/comment', authenticateToken, studyGroupController.addComment);

// Admin Routes (Protected)
router.get('/admin', authenticateAdmin, studyGroupController.getAllStudyGroups);
router.put('/:groupId', authenticateAdmin, studyGroupController.updateStudyGroup);
router.delete('/:groupId', authenticateAdmin, studyGroupController.deleteStudyGroup);

module.exports = router;
