const express = require('express');
const router = express.Router();
const {
    getStates,
    getDistrictsByState,
    getVillagesByDistrict,
    getSchoolsByVillage,
    searchSchoolsByName,
    getSchoolByUdiseCode
} = require('../controllers/schoolController');

// Public routes (no authentication required)
// Get all states
router.get('/states', getStates);

// Get districts by state code
router.get('/districts/:stateCode', getDistrictsByState);

// Get villages by district code
router.get('/villages/:districtCode', getVillagesByDistrict);

// Get schools by village code
router.get('/schools/:villageCode', getSchoolsByVillage);

// Search schools by name
router.get('/search', searchSchoolsByName);

// Get school by UDISE code
router.get('/udise/:udiseCode', getSchoolByUdiseCode);

module.exports = router;
