const express = require('express');
const router = express.Router();
const { authenticateToken } = require('../middleware/auth');
const {
    getUserReferralStats,
    addReferralCoins,
    getProducts,
    getProductById,
    redeemProduct,
    getUserRedemptions
} = require('../controllers/referralController');

// Get user's referral statistics
router.get('/stats', authenticateToken, getUserReferralStats);

// Add coins for successful referral (admin only)
router.post('/add-coins', authenticateToken, addReferralCoins);

// Get all products
router.get('/products', getProducts);

// Get product by ID
router.get('/products/:productId', getProductById);

// Redeem product
router.post('/redeem', authenticateToken, redeemProduct);

// Get user's redemptions
router.get('/redemptions', authenticateToken, getUserRedemptions);

module.exports = router;
