const express = require('express');
const router = express.Router();
const {
    getJobVsPGAnalysis,
    compareSalaryScenarios,
    getCareerProgression,
    createJobVsPGAnalysis,
    updateJobVsPGAnalysis
} = require('../controllers/jobVsPGController');
const { authenticateAdmin } = require('../middleware/adminAuth');

// Public routes
router.get('/:field', getJobVsPGAnalysis);
router.post('/compare', compareSalaryScenarios);
router.get('/:field/progression', getCareerProgression);

// Admin routes
router.post('/', authenticateAdmin, createJobVsPGAnalysis);
router.put('/:analysisId', authenticateAdmin, updateJobVsPGAnalysis);

module.exports = router;
