const express = require('express');
const router = express.Router();
const {
    getIndustryAnalysis,
    getAllIndustries,
    getIndustrySwitching,
    getIndustryJobRoles,
    getFutureOutlook,
    createIndustryAnalysis,
    updateIndustryAnalysis
} = require('../controllers/industryAnalysisController');
const { authenticateAdmin } = require('../middleware/adminAuth');

// Public routes
router.get('/', getAllIndustries);
router.get('/:industry', getIndustryAnalysis);
router.get('/:industry/job-roles', getIndustryJobRoles);
router.get('/switching/industry', getIndustrySwitching);
router.get('/future/outlook', getFutureOutlook);

// Admin routes
router.post('/', authenticateAdmin, createIndustryAnalysis);
router.put('/:analysisId', authenticateAdmin, updateIndustryAnalysis);

module.exports = router;
