const express = require('express');
const router = express.Router();
const {
    getDecisionTree,
    navigateDecisionTree,
    createDecisionTree,
    updateDecisionTree,
    getAllDecisionTrees
} = require('../controllers/decisionTreeController');
const { authenticateAdmin } = require('../middleware/adminAuth');

// Public routes
router.get('/', getAllDecisionTrees);
router.get('/:stage', getDecisionTree);
router.post('/navigate', navigateDecisionTree);

// Admin routes
router.post('/', authenticateAdmin, createDecisionTree);
router.put('/:treeId', authenticateAdmin, updateDecisionTree);

module.exports = router;
