const express = require('express');
const router = express.Router();
const {
    getCareerProgression,
    getIndustrySwitching,
    getCertificationImpact,
    createCareerProgression,
    updateCareerProgression
} = require('../controllers/careerProgressionController');
const { authenticateAdmin } = require('../middleware/adminAuth');

// Public routes
router.get('/:field', getCareerProgression);
router.get('/switching/industry', getIndustrySwitching);
router.get('/:field/certifications', getCertificationImpact);

// Admin routes
router.post('/', authenticateAdmin, createCareerProgression);
router.put('/:progressionId', authenticateAdmin, updateCareerProgression);

module.exports = router;
