const express = require('express');
const router = express.Router();
const careerAnalyticsController = require('../controllers/careerAnalyticsController');
const { authenticateAdmin } = require('../middleware/adminAuth');

// All analytics routes are admin-only
router.get('/dashboard', authenticateAdmin, careerAnalyticsController.getAnalyticsDashboard);
router.get('/quiz', authenticateAdmin, careerAnalyticsController.getQuizAnalytics);
router.get('/study-groups', authenticateAdmin, careerAnalyticsController.getStudyGroupAnalytics);
router.get('/user-progress', authenticateAdmin, careerAnalyticsController.getUserProgressAnalytics);

module.exports = router;
