const mongoose = require('mongoose');

const productSchema = new mongoose.Schema({
    name: {
        type: String,
        required: [true, 'Product name is required'],
        trim: true,
        maxlength: [100, 'Product name cannot exceed 100 characters']
    },
    description: {
        type: String,
        trim: true,
        maxlength: [500, 'Description cannot exceed 500 characters']
    },
    category: {
        type: String,
        required: [true, 'Category is required'],
        enum: ['Electronics', 'Men', 'Women', 'Unisex'],
        trim: true
    },
    subCategory: {
        type: String,
        required: [true, 'Sub category is required'],
        trim: true,
        maxlength: [50, 'Sub category cannot exceed 50 characters']
    },
    imageUrl: {
        type: String,
        required: [true, 'Product image is required'],
        trim: true
    },
    coinsRequired: {
        type: Number,
        required: [true, 'Coins required is required'],
        min: [1, 'Coins required must be at least 1']
    },
    referralsRequired: {
        type: Number,
        required: [true, 'Referrals required is required'],
        min: [1, 'Referrals required must be at least 1']
    },
    coinsPerReferral: {
        type: Number,
        default: 20,
        min: [1, 'Coins per referral must be at least 1']
    },
    isActive: {
        type: Boolean,
        default: true
    },
    stock: {
        type: Number,
        default: 100,
        min: [0, 'Stock cannot be negative']
    },
    tags: [{
        type: String,
        trim: true,
        maxlength: [30, 'Tag cannot exceed 30 characters']
    }]
}, {
    timestamps: true
});

// Index for better query performance
productSchema.index({ category: 1, isActive: 1 });
productSchema.index({ coinsRequired: 1 });

module.exports = mongoose.model('Product', productSchema);
