const mongoose = require('mongoose');

const FreeEducationExamSchema = new mongoose.Schema({
  name: {
    type: String,
    required: true
  },
  fullForm: {
    type: String,
    required: true
  },
  description: {
    type: String,
    required: true
  },
  stage: {
    type: String,
    required: true,
    enum: ['class_6_10', 'class_11_12']
  },
  category: {
    type: String,
    required: true,
    enum: ['jnv', 'sainik', 'aprijc', 'kvpy', 'other']
  },
  conductingBody: {
    type: String,
    required: true
  },
  eligibility: {
    age: {
      min: Number,
      max: Number
    },
    education: String,
    residence: String,
    percentage: Number,
    subjects: [String]
  },
  benefits: [String],
  examPattern: {
    mode: {
      type: String,
      enum: ['online', 'offline', 'both']
    },
    duration: Number,
    totalMarks: Number,
    totalQuestions: Number,
    sections: [{
      name: String,
      marks: Number,
      questions: Number,
      duration: Number
    }]
  },
  syllabus: [String],
  importantDates: {
    applicationStart: Date,
    applicationEnd: Date,
    examDate: Date,
    resultDate: Date
  },
  studyTips: [String],
  parentGuidance: {
    title: String,
    content: String,
    tips: [String]
  },
  isActive: {
    type: Boolean,
    default: true
  }
}, {
  timestamps: true
});

module.exports = mongoose.model('FreeEducationExam', FreeEducationExamSchema);
