const mongoose = require('mongoose');

const CollegeEligibilitySchema = new mongoose.Schema({
  collegeName: {
    type: String,
    required: true
  },
  course: {
    type: String,
    required: true
  },
  exam: {
    type: String,
    required: true
  },
  cutoffs: {
    general: Number,
    obc: Number,
    sc: Number,
    st: Number,
    ews: Number
  },
  rankRanges: {
    safe: {
      min: Number,
      max: Number
    },
    moderate: {
      min: Number,
      max: Number
    },
    risky: {
      min: Number,
      max: Number
    }
  },
  fees: {
    annual: Number,
    total: Number,
    currency: {
      type: String,
      default: 'INR'
    }
  },
  placement: {
    averagePackage: Number,
    highestPackage: Number,
    placementPercentage: Number,
    topRecruiters: [String]
  },
  ranking: {
    nirf: Number,
    qs: Number,
    times: Number
  },
  location: {
    state: String,
    city: String
  },
  isActive: {
    type: Boolean,
    default: true
  }
}, {
  timestamps: true
});

module.exports = mongoose.model('CollegeEligibility', CollegeEligibilitySchema);
